package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class ActivityOperateRequestDto {
    /**
     * 接口版本
     */
    private String ver;
    /**
     * 活动号
     */
    private String activityCode;
    /**
     *活动名称
     */
    private String activityName;
    /**
     * 活动描述
     */
    private String activityDesc;
    /**
     * 商户号
     */
    private String partnerCode;
    /**
     * 活动开始时间
     */
    private String startTime;
    /**
     * 活动结束时间
     */
    private String endTime;
    /**
     * 活动类型：
     * 1：满元减元
     * 2：单品
     * 3：优惠券
     */
    private Integer activityType;
    /**
     * 优先级 默认传0
     */
    private Integer priority;
    /**
     * 优惠类目，0：商家优惠 1：供应商优惠 2：平台优惠
     */
    private Integer type;
    /**
     * 是否分摊，0：不分摊 1：分摊（供应商优惠需设置此字段）   否
     */
    private Integer isApportion;
    /**
     *优惠可使用次数（0无限制，如果活动类型为优惠券，则为每个人该活动可以领取次数）
     */
    private Integer discountTimes;
    /**
     *适用于优惠券活动，该活动可领取总次数
     */
    private Integer totalTimes;
    /**
     * 适用于优惠券活动，优惠券类型，0：满减券  1：代金券
     */
    private Integer couponType;
    /**
     * 审核状态，0：未审核 1：审核通过 2：审核不通过
     */
    private Integer auditStatus;
    /**
     * 活动状态，0：未启用 1：已启用 2：作废
     */
    private Integer activityStatus;
    /**
     * 券有效期开始时间
     */
    private String validityPeriodStart;
    /**
     * 券有效期结束时间
     */
    private String validityPeriodEnd;
    /**
     *创建人
     */
    private String creator;
    /**
     * 优惠列表（单品促销不需要此字段，传入此字段则不允许保存。）
     */
    private List<BenefitBeanDto> benefits;

    private List<StoreBeanDto> stores;

    /**
     * 商品信息 和 优惠时间限制 后续添加
     */
}
