package cn.freemud.entities.db;

import javax.persistence.*;
import java.util.Date;

@Table(name = "saas_link_monitor_log")
public class SaasLinkMonitorLog {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 追踪ID（UUID）
     */
    @Column(name = "tracking_id")
    private String trackingId;

    /**
     * 服务名
     */
    @Column(name = "service_name")
    private String serviceName;

    private String uri;

    private String request;

    private String response;

    /**
     * 请求花费时间（ms）
     */
    @Column(name = "cost_time_mili")
    private Long costTimeMili;

    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * @return id
     */
    public Integer getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取追踪ID（UUID）
     *
     * @return tracking_id - 追踪ID（UUID）
     */
    public String getTrackingId() {
        return trackingId;
    }

    /**
     * 设置追踪ID（UUID）
     *
     * @param trackingId 追踪ID（UUID）
     */
    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    /**
     * 获取服务名
     *
     * @return service_name - 服务名
     */
    public String getServiceName() {
        return serviceName;
    }

    /**
     * 设置服务名
     *
     * @param serviceName 服务名
     */
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    /**
     * @return uri
     */
    public String getUri() {
        return uri;
    }

    /**
     * @param uri
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    /**
     * @return request
     */
    public String getRequest() {
        return request;
    }

    /**
     * @param request
     */
    public void setRequest(String request) {
        this.request = request;
    }

    /**
     * @return response
     */
    public String getResponse() {
        return response;
    }

    /**
     * @param response
     */
    public void setResponse(String response) {
        this.response = response;
    }

    /**
     * 获取请求花费时间（ms）
     *
     * @return cost_time_mili - 请求花费时间（ms）
     */
    public Long getCostTimeMili() {
        return costTimeMili;
    }

    /**
     * 设置请求花费时间（ms）
     *
     * @param costTimeMili 请求花费时间（ms）
     */
    public void setCostTimeMili(Long costTimeMili) {
        this.costTimeMili = costTimeMili;
    }

    /**
     * @return gmt_created
     */
    public Date getGmtCreated() {
        return gmtCreated;
    }

    /**
     * @param gmtCreated
     */
    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }
}