package cn.freemud.amp.config;

import cn.freemud.amp.service.OrderMQService;
import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/11 18:26
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class PushOrderConfig {
    public static final String EXCHANGE_NAME = "topic-Exchange";
    public static final String PUSH_ORDER_QUEUE = "push-order-queue";
    public static final String PUSH_ORDER_QUEUE_ROUTING_KEY = "push-order-queue-routing-key";

    /**
     * 定义基于Fanout 的Exchange。
     * 基于这个代码，也可以非常方便的定义其他的Exchange类型。
     *
     * @return Fanout Exchange
     */
    @Bean
    public Exchange topicExchange() {
        return ExchangeBuilder.topicExchange(EXCHANGE_NAME).durable(true).build();
    }

    /**
     * 写入RabbitMQ使用的默认队列
     *
     * @return
     */
    @Bean
    public Queue pushOrderQueue() {
        return QueueBuilder.durable(PUSH_ORDER_QUEUE).build();
    }

    /**
     * 绑定消息队列
     *
     * @param pushOrderQueue    消息队列
     * @param topicExchange RabbitMQ Fanout Exchange
     * @return 消息队列绑定
     */
    @Bean
    Binding bindingMail(Queue pushOrderQueue, Exchange topicExchange) {
        return BindingBuilder.bind(pushOrderQueue).to(topicExchange).with(PUSH_ORDER_QUEUE_ROUTING_KEY).noargs();
    }

    @Bean
    public OrderMQService orderMQService() {
        return new OrderMQService();
    }
}
