package cn.freemud.platform.sdk.common.log;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.base.log
 * @Description: 异常日志打印
 * @author: aiqi.gong
 * @date: 2017/6/21 10:43
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class ErrorLog {
    private static Logger logger = LoggerFactory.getLogger(ErrorLog.class);

    public static void errorConvertJson(String methodName, String message, String tracking, String appName, long startTime, long endTime, String url, Object requestData, Exception ex) {
        Object requestDataConvert = null;
        if (requestData instanceof String) {
            requestDataConvert = requestData;
        } else {
            requestDataConvert = JSON.toJSONString(requestData);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        String exception = baos.toString();
        logger.error("methodName:{} message:{} appName:{} trackingNo:{} startTime:{} endTime:{} url:{} serverIp:{} request:{} response:{}", methodName, message, appName, tracking, startTime, endTime, url, "", requestDataConvert, exception);
    }



}
