package cn.freemud.service.impl;

import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.OrderAffirmRequestVO;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private MallOrderServiceImpl mallOrderService;

    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;


    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
    }

    @Test
    public void f1() {
        mcCafeOrderService.createOrder(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"ef7f2839e35e7a4f7d21dd1fc26157a4862698a5\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450026\",\"couponCode\":\"\",\"payChannelType\":1,\"reachStoreType\":5,\"takeMealFlag\":\"0\",\"needInvoice\":0,\"orderRemark\":\"\",\"receiveId\":\"\"}", CreateOrderVo.class),
                new StoreResponse.BizVO(),
                JSON.parseObject("{\"activityDiscountsDtos\":[{\"activityCode\":\"CZJG2020091815220412683\",\"activityName\":\"terry0918eee\",\"activityType\":23,\"discountAmount\":-2200}],\"deliveryAmount\":0,\"discountDeliveryAmount\":0,\"isDiscountDelivery\":false,\"originalTotalAmount\":7100,\"packageAmount\":0,\"products\":[{\"activityDiscountsDtos\":[{\"activityCode\":\"CZJG2020091815220412683\",\"activityName\":\"terry0918eee\",\"activityType\":23,\"actualActivityGoodsNumber\":1,\"discountAmount\":2200}],\"activityType\":2,\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"customerCode\":\"508120\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":2300,\"picture\":\"https://picture.sandload.cn/1598681143874.png\",\"productCode\":\"901126\",\"qty\":1,\"skuId\":\"184440231236332839\",\"skuName\":\"红茶拿铁-中杯\",\"spuId\":\"184440231236332839\",\"spuName\":\"红茶拿铁-中杯\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":2200},{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"2217\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":1900,\"parentProductId\":\"184437712179293469\",\"picture\":\"https://picture.sandload.cn/1598675643524.png\",\"productType\":6,\"qty\":2,\"skuId\":\"181574788508098858\",\"skuName\":\"中杯拿铁\",\"spuId\":\"181574788508098858\",\"spuName\":\"中杯拿铁\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"508134\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":2100,\"parentProductId\":\"184437712179293469\",\"picture\":\"https://picture.sandload.cn/1598675940164.png\",\"productType\":6,\"qty\":2,\"skuId\":\"184434761663638803\",\"skuName\":\"经典芝士蛋糕\",\"spuId\":\"184434761663638803\",\"spuName\":\"经典芝士蛋糕\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":3200,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"508131\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":4800,\"picture\":\"https://picture.sandload.cn/1598678713405.png\",\"productCode\":\"508131\",\"productType\":6,\"qty\":2,\"skuId\":\"184437712179293469\",\"skuName\":\"早餐啡常搭\",\"spuId\":\"184437712179293469\",\"spuName\":\"早餐啡常搭\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"totalAmount\":4900,\"totalDiscountAmount\":2200}", ShoppingCartGoodsDto.class),
                new OrderExtendedReq(),
                OrderClientType.SAAS,"www");
    }

    @Test
    public void testPaySuccess() {
        //0元支付
        String fmId = "SPAY" + ValidationCode.getRandomUuid();
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(100);
        message.setOut_trade_no(fmId);
        message.setTrans_id("16303606485084241800003");
        message.setTotal_fee(0);
        message.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
        message.setPlatform_coupon(0);
        message.setMerchant_coupon(0);
        mallOrderService.paySuccessCallback(message);
    }

    @Test
    public void testAffirm() {
        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
        requestVO.setPartnerId("1864");
        requestVO.setShopId("8899");
        requestVO.setSessionId("123123");
        requestVO.setChannelType("saasmall");
        requestVO.setOid("16303606485084241800003");
        mallOrderService.orderAffirm(requestVO);
    }
}
