package cn.freemud.service.impl;

import cn.freemud.adapter.DeliveryAdapter;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.CreateDeliveryVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.entities.vo.encircle.EmptyTableNumberVo;
import cn.freemud.enums.OrderBeanType;
import cn.freemud.service.EncircleOrderService;
import cn.freemud.service.thirdparty.DeliveryFeiginClient;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.deliverycenter.response.CreateDeliveryOrderResponseDto;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import org.apache.commons.lang.ObjectUtils;
import org.junit.Test;
import org.junit.Before;
import org.junit.After;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Map;

/**
 * EncircleOrderServiceImpl Tester.
 *
 * @author qin.zhou
 * @version 1.0
 * @since <pre>���� 9, 2019</pre>
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class EncircleOrderServiceImplTest {

    @Autowired
    private EncircleOrderService encircleOrderService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private StoreCenterService storeCenterService;
    @Value("${saas.order.delivery.callBackUrl}")
    private String deliveryCallBackUrl;

    @Autowired
    private DeliveryFeiginClient deliveryFeiginClient;
    @Autowired
    private DeliveryAdapter deliveryAdapter;

    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
    }

    /**
     * Method: createReserveOrder(CreateOrderVo createOrderVo)
     */
    @Test
    public void testCreateReserveOrder() throws Exception {
//TODO: Test goes here...
        CreateOrderVo createOrderVo = new CreateOrderVo();
        createOrderVo.setTableNumber("5");
        createOrderVo.setSessionId("fbc82ad9a7449590bcd56f96db1b11352e1f3470");
        createOrderVo.setPartnerId("1864");
        createOrderVo.setShopId("2700968");
        createOrderVo.setPeopleNumber(12);
        System.out.println(JSON.toJSONString(encircleOrderService.createReserveOrder(createOrderVo)));
    }


    @Test
    public void testd() throws Exception {
        Map<String, QueryOrdersResponseDto.DataBean.OrderBean> orderBeans = orderService.getOrderBeanByOrderId("18550453673517366500002");
        QueryOrdersResponseDto.DataBean.OrderBean orderBean = orderBeans.get(OrderBeanType.SAASORDER.getCode());
        //获取门店信息
        StoreResponse storeInfo = storeCenterService.getStoreInfo(new StoreInfoRequest(orderBean.getCompanyId(), orderBean.getShopId()), "");
        if (storeInfo == null || ObjectUtils.notEqual(cn.freemud.management.enums.ResponseResult.SUCCESS.getCode(), storeInfo.getStatusCode().toString()) || storeInfo.getBizVO() == null) {
            //return sendPaySuccessNoticeMessage();
        }
        CreateDeliveryVo createDeliveryVo = deliveryAdapter.buildDeliveryOrderRequestDto(orderBean, storeInfo, deliveryCallBackUrl,"");
        //创建配送单
        CreateDeliveryOrderResponseDto deliveryResponse = deliveryFeiginClient.deliveryOrderAdd(createDeliveryVo);
        //创建配送单失败，更新订单为异常单
        if (deliveryResponse == null || 100 != deliveryResponse.getCode() || deliveryResponse.getData() == null) {
            String deliveryId = deliveryResponse != null && deliveryResponse.getData() != null ? deliveryResponse.getData().getDeliveryId() : "";
            String operator =  "系统" ;
            //updateDeliveryAbnormal(orderBean.getCompanyId(), orderBean.getOid(), deliveryId, operator);
           // return sendPaySuccessNoticeMessage();
        }
    }

    /**
     * Method: updateReserveOrder(CreateReserveOrderVo createReserveOrderVo)
     */
    @Test
    public void testUpdateReserveOrder() throws Exception {
//TODO: Test goes here...
        CreateReserveOrderVo reserveOrderVo = new CreateReserveOrderVo();
        reserveOrderVo.setSessionId("00e7be90e5fd45b5568da134a36a8d44ea01bd92");
        reserveOrderVo.setRepastNumber(5);
        System.out.println(JSON.toJSONString(encircleOrderService.updateReserveOrder(reserveOrderVo)));
    }

    /**
     * Method: queryOrderInfo(CreateReserveOrderVo createReserveOrderVo)
     */
    @Test
    public void testQueryOrderInfo() throws Exception {
//TODO: Test goes here...
        CreateReserveOrderVo createReserveOrderVo = new CreateReserveOrderVo();
        createReserveOrderVo.setSessionId("00e7be90e5fd45b5568da134a36a8d44ea01bd92");
        System.out.println(JSON.toJSONString(encircleOrderService.queryOrderInfo(createReserveOrderVo)));
    }

    /**
     * Method: createPrepaymentOrder(CreateReserveOrderVo createReserveOrderVo)
     */
    @Test
    public void testCreatePrepaymentOrder() throws Exception {
//TODO: Test goes here...
        CreateReserveOrderVo createReserveOrderVo = new CreateReserveOrderVo();
        createReserveOrderVo.setSessionId("fbc82ad9a7449590bcd56f96db1b11352e1f3470");
        System.out.println(JSON.toJSONString(encircleOrderService.createPrepaymentOrder(createReserveOrderVo)));
    }

    /**
     * Method: emptyTableNumber(EmptyTableNumberVo emptyTableNumberVo)
     */
    @Test
    public void testEmptyTableNumber() throws Exception {
//TODO: Test goes here... 
    }

    /**
     * Method: paySuccessCallback(PaysuccessNoticeMessage message)
     */
    @Test
    public void testPaySuccessCallback() throws Exception {
//TODO: Test goes here... 
    }


    /**
     * Method: redisLockInfo(AssortmentCustomerInfoVo assortmentCustomerInfoVo, RedisCacheEnum redisCacheEnum)
     */
    @Test
    public void testRedisLockInfo() throws Exception {
//TODO: Test goes here... 
/* 
try { 
   Method method = EncircleOrderServiceImpl.getClass().getMethod("redisLockInfo", AssortmentCustomerInfoVo.class, RedisCacheEnum.class); 
   method.setAccessible(true); 
   method.invoke(<Object>, <Parameters>); 
} catch(NoSuchMethodException e) { 
} catch(IllegalAccessException e) { 
} catch(InvocationTargetException e) { 
} 
*/
    }

    /**
     * Method: createGroupOrderInfo(CreateOrderVo createOrderVo, AssortmentCustomerInfoVo assortmentCustomerInfoVo, StoreBaseResponseDto<ProductListDto> dishWareProductList)
     */
    @Test
    public void testCreateGroupOrderInfo() throws Exception {
//TODO: Test goes here... 
/* 
try { 
   Method method = EncircleOrderServiceImpl.getClass().getMethod("createGroupOrderInfo", CreateOrderVo.class, AssortmentCustomerInfoVo.class, StoreBaseResponseDto<ProductListDto>.class); 
   method.setAccessible(true); 
   method.invoke(<Object>, <Parameters>); 
} catch(NoSuchMethodException e) { 
} catch(IllegalAccessException e) { 
} catch(InvocationTargetException e) { 
} 
*/
    }

    /**
     * Method: queryExistWeightNoNum(QueryOrderByIdResponse queryOrderByIdResponse)
     */
    @Test
    public void testQueryExistWeightNoNum() throws Exception {
//TODO: Test goes here... 
/* 
try { 
   Method method = EncircleOrderServiceImpl.getClass().getMethod("queryExistWeightNoNum", QueryOrderByIdResponse.class); 
   method.setAccessible(true); 
   method.invoke(<Object>, <Parameters>); 
} catch(NoSuchMethodException e) { 
} catch(IllegalAccessException e) { 
} catch(InvocationTargetException e) { 
} 
*/
    }

    /**
     * Method: pullThirdOrderInfo(String partnerId, String wxAppid, String thirdOrderCode, String oid)
     */
    @Test
    public void testPullThirdOrderInfo() throws Exception {
//TODO: Test goes here... 
/* 
try { 
   Method method = EncircleOrderServiceImpl.getClass().getMethod("pullThirdOrderInfo", String.class, String.class, String.class, String.class); 
   method.setAccessible(true); 
   method.invoke(<Object>, <Parameters>); 
} catch(NoSuchMethodException e) { 
} catch(IllegalAccessException e) { 
} catch(InvocationTargetException e) { 
} 
*/
    }

    /**
     * Method: compareToOrderBeanInfo(QueryOrderByIdResponse queryOrderByIdResponse, QueryOrderByIdResponse queryOrderByIdResponseCopy)
     */
    @Test
    public void testCompareToOrderBeanInfo() throws Exception {
//TODO: Test goes here... 
/* 
try { 
   Method method = EncircleOrderServiceImpl.getClass().getMethod("compareToOrderBeanInfo", QueryOrderByIdResponse.class, QueryOrderByIdResponse.class); 
   method.setAccessible(true); 
   method.invoke(<Object>, <Parameters>); 
} catch(NoSuchMethodException e) { 
} catch(IllegalAccessException e) { 
} catch(InvocationTargetException e) { 
} 
*/
    }

    @Test
    public void testQueryTableNumberStatus()throws Exception{

        EmptyTableNumberVo emptyTableNumberVo = new EmptyTableNumberVo();
        emptyTableNumberVo.setPartnerId("1864");
        emptyTableNumberVo.setShopId("2700968");
        emptyTableNumberVo.setSessionId("fbc82ad9a7449590bcd56f96db1b11352e1f3470");
        emptyTableNumberVo.setTableNumber("6");
        System.out.println(JSON.toJSONString(encircleOrderService.queryTableNumberStatus(emptyTableNumberVo)));
    }

} 
