/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PaymentClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 支付服务
 * @author: liming.guo
 * @date: 2018/5/12519:24
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.*;
import com.freemud.sdk.api.assortment.order.request.payment.UnifiedOrderApplicationRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.web.bind.annotation.*;


@FeignClient(name = "payment-center-application-api",url="${saas.paymentcenter.application.api.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PaymentApplicationClient {

    /**
     * 统一下单
     */
    @PostMapping("/payment/application/unifiedOrder")
    UnifiedOrderApiResponse unifiedOrder(@RequestBody UnifiedOrderApplicationRequest unifiedOrderApplicationRequest, @RequestHeader("partnerId") String partnerId);

}
