/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 18:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.promotion.ShoppingCartGoodsResponse;
import cn.freemud.entities.vo.ActivityClassifyCouponBean;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.GetMemberCouponRequestVo;

import java.util.List;

public interface CouponService {

    /**
     * 获取卡券详情
     *
     * @param requestVo
     * @return
     */
    GetCouponDetailResponseDto getMemberCoupon(GetMemberCouponRequestVo requestVo);

    /**
     * 获取卡券服务商户密钥
     */
    String getAppSecret(String partnerId);

    /**
     * 调用会员接口列表
     *
     * @param cartGoods
     * @return
     */
    ActivityClassifyCouponBean availableCoupon(List<ShoppingCartGoodsResponse.CartGoodsDetailDto> cartGoods, String partnerId, String userId, String storeId, String couponCode, boolean hasGoodsCoupon, Integer orderType);
}
