package cn.freemud.fuyou.service.processor;


import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.Collections;
import java.util.Map;

@Component
@Slf4j
public class EventProcessorRegister extends ApplicationObjectSupport {
//Collections.emptyMap()

    private static Map<Integer, EventProcessor> processorMap = Maps.newHashMap();

    @PostConstruct
    private void init() {
        Map<String, EventProcessor> beans = getApplicationContext().getBeansOfType(EventProcessor.class);
        log.info("EventProcessorRegister:bean:{}",beans);
        if (!CollectionUtils.isEmpty(beans)) {
            beans.values().stream().forEach((EventProcessor obj) -> {
                        processorMap.put(obj.getEvent(), obj);
                    }


            );
        }
    }

    public EventProcessor getEventProcessor(Integer event) {
        //todo  dev环境init初始化 beans =null
        if(processorMap.get(event) ==null){
            init();
        }
        return processorMap.get(event);
    }
}
