package cn.freemud.fuyou.feign.request;

import lombok.Getter;

/**
 * 订单状态
 * @author jiewen.li
 */
public enum TradeState {
    /**
     * 未知
     */
    UNKNOWN("UNKNOWN"),
    /**
     * 成功
     */
    SUCCESS("SUCCESS"),
    /**
     * 退款
     */
    REFUND("REFUND"),
    /**
     * 未支付
     */
    NOTPAY("NOTPAY"),
    /**
     * 已关闭
     */
    CLOSED("CLOSED"),
    /**
     *
     */
    REVOKED("REVOKED"),
    /**
     * 支付中
     */
    USERPAYING("USERPAYING"),
    /**
     * 支付失败
     */
    PAYERROR("PAYERROR"),
    /**
     * 交易已结束
     */
    FINISHED("FINISHED")
    ;

    private final String tradeState;
    private TradeState(String tradeState) {
        this.tradeState = tradeState;
    }
}
