package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * All rights Reserved,Designed By www.freemud.cn
 *
 * @Title:ReturnScoreRequest
 * @package cn.freemud.customer.microservice.propertymicro.vo.req
 * @Description:${TODO}(用一句话描述该文件做什么)
 * @Author:xiaofeng.han
 * @Date:2019/4/16 14:12
 * @Version V1.0
 * @Copyright:2018www.freemud.cn Inc.All rights reserved. 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ReturnScoreRequest extends BaseRequest {

    @ApiModelProperty(value = "会员编号", required = true)
    @NotBlank(message = "会员编号不能为空")
    private String memberId;

    @ApiModelProperty("操作类型{1消费送积分2积分支付退回3积分签到4手动赠送5等级升级送积分6割接7生日送8注册送9完善送10消费满赠11手动扣减12积分兑换13积分清理14积分支付15消费送积分扣回16等级升级退积分17消费满赠扣回}")
    private List<Integer> operationTypes;

    @ApiModelProperty(value = "订单编号", required = true)
    @NotBlank(message = "订单编号不能为空")
    private String orderId;

    @ApiModelProperty("活动编号")
    private String activityCode;

    @ApiModelProperty("备注")
    private String remark;

}
