package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;

/**
 * 退款请求对象
 *
 * @author Tony
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "申请退款请求v2")
public class RefundReq extends BasicOfflineReq {

    @ApiModelProperty(value = "退款交易序号, 由第三方系统生成", position = 8)
    private String frontRefundId;

    @ApiModelProperty(value = "非码交易流水号, 支付/下单时有支付系统下发", position = 8)
    private String transactionCode;

    @Min(value = 0, message = "支付总金额最小是0")
//    @NotNull(message = "支付总金额不能为空")
    @ApiModelProperty(value = "总金额", position = 10)
    private Integer totalAmount;

    @Min(value = 1, message = "退款金额最小是1")
//    @NotNull(message = "退款金额不能为空")
    @ApiModelProperty(value = "退款金额", position = 11)
    private Integer refundAmount;

    @ApiModelProperty(value = "退款原因描述", position = 12)
    private String refundDesc;

    @ApiModelProperty(value = "退款回调地址", position = 13)
    private String notifyUrl;

    @ApiModelProperty(value = "退款时分账规则",position = 13)
    private String accountDivided;

}
