package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * All rights Reserved,Designed By www.freemud.cn
 *
 * @Title:HelloController
 * @Package spring.cloud.controller
 * @Description:幂等性基础类
 * @Author: gyb
 * @Date:2018/3/1 15:02
 * @Version V1.0
 * @Copyright:2018www.freemud.cn Inc.All rights reserved. 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class BaseIdempotencyRequest extends BaseRequest{

    @ApiModelProperty(value = "业务ID{调用方保证唯一}", required = true)
    @NotBlank(message = "业务ID不能为空")
    private String idempotencyBussinessId;

    @ApiModelProperty(value = "业务类型{1注册送 2发放经验值 3等级升级 4等级降级 5积分支付 6消费送积分 7消费满赠 8生日送 9定时送 10储值支付 11储值充值 12完善资料送 13等级升级送积分 14储值卡投放 15会员消费数据增加 16会员消费数据冲正 17集点发放 18兑换集点 19积分商城兑换}", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String idempotencyBussinessType;

}
