package cn.freemud.fuyou.controller;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import  com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.OrderDiscountService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 优惠
 */
@RestController
@RequestMapping("/discount")
public class DiscountController {

    private final OrderDiscountService orderDiscountService;

    public DiscountController(OrderDiscountService orderDiscountService) {
        this.orderDiscountService = orderDiscountService;
    }

    /**
     * 订单优惠 积分，券，svc
     * @param request
     * @return
     */
    @PostMapping("/")
    @ApiAnnotation(logMessage = "/")
    public BaseResponse pay(@RequestBody @Validated DiscountRequest request) {
        return orderDiscountService.discount(request);
    }
}
