package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: ScopeConfigType
 * @Package cn.freemud.enums
 * @Description: 门店配送范围类型
 * @author: hang.chai
 * @date: 2018/12/7 9:39
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum ScopeConfigType {

    DEFINITION("1", "自定义"),
    RADIUS("2", "按半径");

    ScopeConfigType(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private String code;

    private String message;


    public static ScopeConfigType getByCode(String code) {
        for (ScopeConfigType type : values()) {
            if (code.equals(type.getCode())) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
