package cn.freemud.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderRefundStatus
 * @Package com.freemud.platform.order.enums
 * @Description:
 * @author: yuhao.chi
 * @date: 2019/5/23 17:25
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public enum PayChannelEnum {

    //1. 微信，2.支付宝，3.现金 4.svc，5.积分
    WECHAT(1, "微信"),
    ALIPAY(2, "支付宝"),
    CASH(3, "现金"),
    SVC(4, "svc"),
    INTEGRAL(5, "积分"),
    COUPON(6, "优惠券"),

    ;

    private Integer code;
    private String desc;


    /**
     * 支付enum
     */
    public static Map<Integer, PayChannelEnum> payChannelEnumMap = ImmutableMap.of(PayChannelEnum.SVC.getCode(), PayChannelEnum.SVC,
            PayChannelEnum.WECHAT.getCode(), PayChannelEnum.WECHAT,
            PayChannelEnum.ALIPAY.getCode(), PayChannelEnum.ALIPAY
    );


    PayChannelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayChannelEnum getPayChannelEnum(int code) {
      return   Arrays.stream(PayChannelEnum.values()).filter(obj->obj.getCode().intValue()==code).findFirst().get();
    }





    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
