/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单状态
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum OrderStatus {

    TAKE_ORDER(1, "下单"),
    WAIT_PAY(2, "待支付"),
    RECEIPT(3, "接单"),
    DISTRIBUTION(4, "配送中"),
    COMPLETE(5, "完成"),
    CALCEL(6, "取消"),
    REFUSE(7,"拒单"),
    COMPLETE_MAKE(31, "制作完成");

    private Integer code;
    private String desc;

    OrderStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer[] getAllCodes() {
        Integer[] codeArray = new Integer[values().length];
        int i = 0;
        for (OrderStatus orderStatus : values()) {
            codeArray[i] = orderStatus.getCode();
            i++;
        }
        return codeArray;
    }

    public static OrderStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OrderStatus orderStatus : values()) {
            if (orderStatus.getCode().equals(code)) {
                return orderStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
