package cn.freemud.entities.vo;

import cn.freemud.entities.dto.UserDeliveryInfoDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: SellCouponCreateOrderVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping1.wu
 * @date: 2020/5/21 17:27
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SellCouponCreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    @NotEmpty(message = "shopId 门店号不能为空")
    private String shopId;

    //一键买券必传
    @NotEmpty(message = "skuId 不能为空")
    private String skuId;

    /**
     * svc 储值卡支付使用
     */
    private String cardCode;

    @NotEmpty(message = "menuType 不能为空")
    private String menuType;

    /**
     * form_id  用于金额是0的情况，支付宝模板消息需要传
     */
    private String formId;

    /**
     * 业务类型
     */
    @NotEmpty(message = "bizType 业务类型不能为空")
    private String bizType;

    /**
     * 版本号
     */
//    @NotEmpty(message = "version 版本号不能为空")
    private String version;

}
