package cn.freemud.entities.vo;

import lombok.Data;

@Data
public class ProductInfo {

    /**
     *  商品编号
     *  productCode不能为空
     */
    private String productCode;

    /**
     * 归属餐品 ID（一般套餐或者特殊要求时，该 ID 指向主餐品 ID） 0或者-1代表一级餐品数据； 一份餐品数据存在多级(麦咖啡餐道专用)
     */
    private Long parentCode;

    /**
     * "税率代码：10-餐品费用，13-非餐品费用；仅 taxFlag=1 改字段生效，具体税率代码参考麦 中定义")(麦咖啡餐道专用)
     *
     */
    private String taxId;

    /**
     * 税率：餐品费用-6，非餐品费用-13；仅 taxFlag=1 改字段生效，具体税率值参考麦中 定义 (麦咖啡餐道专用)
      */
    private Double taxRate;

    /**
     * "优惠金额 单位:分"
      */

    private Long discountAmount;
    // ---
    /**
     *  商品名称
     *  productName不能为空
     */
    private String productName;

    /**
     * 商品数量
     * productNumber不能为空
     * productNumber不能小于1
     */
    private Integer productNumber;


    /**
     * 商品价格（分）
     * productPrice不能为空
     */
    private Integer productPrice;

    /**
     * 商品尺寸
     */
    private Integer productSize;

    /**
     * 商品图片 微信物流必传
     */
    private String productImg;

    /**
     * 商品备注
     */
    private String productRemark;

    /**
     *  小计(单位分)(麦咖啡餐道专用)
      */

    private Integer cumulatedTotal;

    /**
     *  "分组名称，如果订单采用分组形式，该参数为比传" (麦咖啡餐道专用)
     */
    private String GroupName;


}
