package cn.freemud.entities.dto.promotion;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

@Data
public class CalculationDiscountGoodsDto {

    private String cartGoodsUid;

    @NotNull(message = "不可为空")
    private String goodsId;
    /**
     * 商品数量
     */
    @NotNull(message = "不可为空")
    @Min(value = 1, message = "商品数量不能小于1")
    private Integer goodsQuantity;
    /**
     * 商品原价
     */
    @NotNull(message = "不可为空")
    @Min(value = 0, message = "商品原价不能小于0")
    private Integer originalPrice;

    /**
     * 商品现价
     */
    private Integer nowPrice;

    /**
     * 实付金额
     */
    private Integer realAmount;

    private String firstCategory;

    /**
     * 品类
     */
    private String category;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 总优惠金额
     */
    private Integer discountAmount;

    /**
     * 实际计算的商品数量
     */
    private Integer actualGoodsNumber;

    private Integer  goodsWeight;
    /**
     * 是否计算套餐
     */
    private boolean meal = false;

    /**
     * 是否是赠送商品或换购商品
     */
    private boolean gift = false;

    public boolean getMeal(){return meal;}

    public void setMeal(boolean meal){
        this.meal = meal;
    }
    /**
     * 套餐固定商品组
     */
    private List<CalculationMealGoodsDto> groupCombox;

    @JSONField(serialize = false)
    private Map<Integer, List<CalculationGoodsActivityDto>> discountMap;

    private List<CalculationGoodsActivityDto> discounts;

    /**
     * 重量,最多四位小数，单位kg
     */
    private Double weight;

    /**
     * 单位
     */
    private String unit;
}