package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

public class ActivityBenefitVO {
    private Long benefitId;
    @ApiModelProperty(value="优惠名称", name="benefitName", example="满10元减3元", required = true)
    @NotNull(message = "优惠名称不能为空")
    private String benefitName;
    @ApiModelProperty(value="优惠门槛（分）", name="thresholdAmount", example="1000")
    private Integer thresholdAmount;
    @ApiModelProperty(value="优惠金额（分）", name="discountAmount", example="300")
    private Integer discountAmount;
    @ApiModelProperty(value="优惠阶梯", name="benefitSeq", example="1")
    private Integer benefitSeq;
    @ApiModelProperty(value="优惠折扣（百分制）", name="benefitRebate", example="80")
    private Integer benefitRebate;
    @ApiModelProperty(value="最大数量/金额（分）", name="benefitNumber", example="100")
    private Integer benefitNumber;
    @ApiModelProperty(value="最小数量/金额（分）", name="benefitMinNumber", example="1")
    private Integer benefitMinNumber;
    @ApiModelProperty(value="赠送积分", name="integral", example="100")
    private Integer integral;
    @ApiModelProperty(value="赠送倍数", name="multiple", example="2")
    private Integer multiple;
    @ApiModelProperty(value="优惠类型", name="benefitType", example="3")
    private Integer benefitType;
    @ApiModelProperty(value="阶梯换购商品列表", name="exchangeGoods")
    @Valid
    private List<ActivitySendGoodsVO> exchangeGoods;
    @ApiModelProperty(value="阶梯赠券列表", name="sendCoupons")
    @Valid
    private List<ActivitySendCouponVO> sendCoupons;
    @ApiModelProperty(value="阶梯商品列表", name="goodsList")
    @Valid
    private List<ActivityGoodsVO> goodsList;
    @ApiModelProperty(value="满足积分组合商品列表", name="combinationGoodsList")
    @Valid
    private List<ActivityCombinationGoodsVO> combinationGoodsList;
    @ApiModelProperty(value = "赠送商品列表", name = "sendGoodsList")
    @Valid
    private List<ActivitySendGoodsVO> sendGoodsList;

    public Long getBenefitId() {
        return benefitId;
    }

    public void setBenefitId(Long benefitId) {
        this.benefitId = benefitId;
    }

    public Integer getBenefitNumber() {
        return benefitNumber;
    }

    public void setBenefitNumber(Integer benefitNumber) {
        this.benefitNumber = benefitNumber;
    }

    public String getBenefitName() {
        return benefitName;
    }

    public void setBenefitName(String benefitName) {
        this.benefitName = benefitName;
    }

    public Integer getThresholdAmount() {
        return thresholdAmount;
    }

    public void setThresholdAmount(Integer thresholdAmount) {
        this.thresholdAmount = thresholdAmount;
    }

    public Integer getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(Integer discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getBenefitSeq() {
        return benefitSeq;
    }

    public void setBenefitSeq(Integer benefitSeq) {
        this.benefitSeq = benefitSeq;
    }

    public Integer getBenefitRebate() {
        return benefitRebate;
    }

    public void setBenefitRebate(Integer benefitRebate) {
        this.benefitRebate = benefitRebate;
    }

    public List<ActivitySendGoodsVO> getExchangeGoods() {
        return exchangeGoods;
    }

    public void setExchangeGoods(List<ActivitySendGoodsVO> exchangeGoods) {
        this.exchangeGoods = exchangeGoods;
    }

    public List<ActivitySendCouponVO> getSendCoupons() {
        return sendCoupons;
    }

    public void setSendCoupons(List<ActivitySendCouponVO> sendCoupons) {
        this.sendCoupons = sendCoupons;
    }

    public List<ActivityGoodsVO> getGoodsList() {
        return goodsList;
    }

    public void setGoodsList(List<ActivityGoodsVO> goodsList) {
        this.goodsList = goodsList;
    }

    public Integer getBenefitMinNumber() {
        return benefitMinNumber;
    }

    public void setBenefitMinNumber(Integer benefitMinNumber) {
        this.benefitMinNumber = benefitMinNumber;
    }

    public List<ActivityCombinationGoodsVO> getCombinationGoodsList() {
        return combinationGoodsList;
    }

    public void setCombinationGoodsList(List<ActivityCombinationGoodsVO> combinationGoodsList) {
        this.combinationGoodsList = combinationGoodsList;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public Integer getMultiple() {
        return multiple;
    }

    public void setMultiple(Integer multiple) {
        this.multiple = multiple;
    }

    public List<ActivitySendGoodsVO> getSendGoodsList() {
        return sendGoodsList;
    }

    public void setSendGoodsList(List<ActivitySendGoodsVO> sendGoodsList) {
        this.sendGoodsList = sendGoodsList;
    }

    public void setBenefitType(Integer benefitType) { this.benefitType = benefitType; }

    public Integer getBenefitType() { return benefitType; }
}