/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetReceiveListResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: ping.wu
 * @date: 2018/6/29 14:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetReceiveAddressListResponseDto {

    private String code;
    private String message;
    private ResultBean data;
    private String ver;

    @NoArgsConstructor
    @Data
    public static class ResultBean {

        private List<ReceivingAddress> list;
        private Integer totalPages;
        private Integer pageNum;
        private Integer pageSize;
        private Integer totalCount;

        @NoArgsConstructor
        @Data
        public static class ReceivingAddress {
            /**
             * 会员Id
             */
            private String memberId;
            private String createTime;
            private String distance;
            private String addressId;
            /**
             * 默认地址 1 不是默认 2 是默认
             */
            private Integer isDefault;
            /**
             * 标签类型{1：公司 2：家 3：学校 4：自定义}
             */
            private Integer labelType;
            /**
             * 标签名称
             */
            private String labelName;
            private String latitude;
            private String longitude;
            private String partnerId;
            private String receiveAddress;
            /**
             * 详细地址
             */
            private String detailAddress = "none";
            /**
             * 收货人号码
             */
            private String mobile;
            private String receiveName;
            private String sendMobile;
            private Integer sex;
            private String updateTime;
        }
    }

}
