package com.freemud.sdk.api.assortment.shoppingcart.exception;

import com.freemud.application.sdk.api.exception.IgnoreErrorAnnotation;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CartResponseConstant;
import lombok.Data;

/**
 * 自定义服务异常抛出
 * message 错误信息
 */
@Data
@SuppressWarnings("serial")
@IgnoreErrorAnnotation
public class ServiceException extends RuntimeException {

    private CartResponseConstant constant;

    private String message;

    public ServiceException(CartResponseConstant constant) {
        this.constant = constant;
        this.message = constant.getMessage();
    }

    public ServiceException(CartResponseConstant constant, String message) {
        this.constant = constant;
        this.message = message;
    }

}
