package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.QueryOrderAccountType;
import lombok.Builder;
import lombok.Data;

/**
 * 订单结算明细 包含所有其他优惠信息
 */
@Data
@Builder
public class CreateOrderAccountRequest extends BaseConfig {
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 活动id
     */
    private String accountId;
    /**
     * 活动名称
     */
    private String name;
    /**
     * 活动类型 QueryOrderAccountType
     */
    private QueryOrderAccountType accountType;
    /**
     * 结算价格 包装费，配送费为正数 ，优惠券，限时特价，满减为负数
     */
    private Long price;
    /**
     * 排序
     */
    private Integer sequence;
    /**
     * 自定义字段
     */
    private String addInfo;

    private String productId;

    private Integer discountQty;

    /**
     * 真实费用 满减配送费 计算实际产生的配送费用
     */
    private Long actualPrice;
}
