package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ActivitySprint
 * @Package cn.freemud.enums
 * @Description: 简单描述下这个类是做什么用的
 * @author: biao.zhang
 * @date: 2018/10/11 17:58
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum ActivityResultCodeEnum {
    //0：不参加 1：参加
    NON_PARTICIPATE(0, "不需要参加活动"),
    PARTICIPATE(1, "参加活动"),
    GOODFILTER(2, "商品状态已变化"),
    GOOD_NOT_IN_MUNU(3, "商品不在菜单"),
    GOOD_NOT_AVAILABLE(4, "商品在门店下不可售"),
    NO_ACTIVITY(5, "没有可用活动"),
    STOCK_LIMIT(6, "商品库存不足"),
    ;

    private Integer code;

    private String desc;

    ActivityResultCodeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
