package cn.freemud.management.service.handle;

import cn.freemud.management.adapter.PaymentSdkAdapter;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesOrderResp;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest;
import com.freemud.sdk.api.assortment.payment.response.OrderRefundResponse;
import com.freemud.sdk.api.assortment.payment.service.StandardPaymentService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PaymentService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 10:45
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class PaymentHandle {

    private static final String SUCCESS="100";

    @Autowired
    private StandardPaymentService standardPaymentService;
    @Autowired
    private PaymentSdkAdapter paymentSdkAdapter;
    @Autowired
    private OrderSdkService orderSdkService;


    /**
     * 退款
     * @param request
     * @param orderBean
     * @return
     */
    public PayRefundResponse refund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        PayRefundStatus refundStatus=PayRefundStatus.SUCCESS;
        OrderRefundRequest orderRefundRequest = paymentSdkAdapter.getOrderRefundRequest(orderBean,getRefundAmount(orderBean));
        if (ObjectUtils.equals(orderBean.getAmount(), 0)) {
            return handlePayRefundResponse(refundStatus,orderRefundRequest.getRefundId());
        }
        BaseResponse<OrderRefundResponse> orderRefundResponse;
        try {
            orderRefundResponse = standardPaymentService.orderRefund(orderRefundRequest, "");
        }catch (Exception ex){
            ErrorLog.errorConvertJson(this.getClass(), "refundError", ex);
            throw new OrderServiceException(ResponseResult.REFUND_EXCEPTION);
        }
        if (orderRefundResponse==null){
            throw new OrderServiceException(ResponseResult.REFUND_EXCEPTION);
        }
        if (ObjectUtils.notEqual(orderRefundResponse.getCode(),SUCCESS)){
            throw new OrderServiceException(ResponseResult.REFUND_FAIL,orderRefundResponse.getMessage());
        }
        refundStatus=ObjectUtils.equals( PayRefundStatus.SUCCESS.getCode(), orderRefundResponse.getData().getRefundStatus())?PayRefundStatus.SUCCESS:PayRefundStatus.RUNNING;
        return handlePayRefundResponse(refundStatus,orderRefundRequest.getRefundId());
    }

    /**
     * 获取退款金额
     *
     * @param data
     * @return
     */
    private BigDecimal getRefundAmount(QueryOrdersResponse.DataBean.OrderBean  data) {
        BigDecimal refundAmount = new BigDecimal(data.getAmount());
        com.freemud.application.sdk.api.ordercenter.response.BaseResponse<List<AfterSalesOrderResp>> listBaseResponse = orderSdkService.queryAfterSaleByOrderCode(data.getCompanyId(), data.getOid());
        if (CollectionUtils.isNotEmpty(listBaseResponse.getResult())){
            refundAmount=new BigDecimal(listBaseResponse.getResult().get(0).getActualAmount());
        }
        return refundAmount;
    }

    private PayRefundResponse handlePayRefundResponse(PayRefundStatus refundStatus, Long refundId){
        PayRefundResponse payRefundResponse = new PayRefundResponse();
        payRefundResponse.setPayRefundStatus(refundStatus);
        payRefundResponse.setRefundId(refundId.toString());
        return payRefundResponse;
    }
}
