package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yuanyuan.jing  2018/12/14 18:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "查询订单请求")
@Deprecated
public class QueryChannelRequest extends QueryChannelReq {

    @ApiModelProperty(value = "非码交易流水号", position = 9)
    private String fmId;

    @ApiModelProperty(value = "三方交易号", position = 10)
    private String thirdPartTradeNo;

    /**
     * 冗余基础字段
     */
    @ApiModelProperty(value = "接口版本，必须为2", position = 1)
    private String ver;

    @ApiModelProperty(value = "商户编号（由非码提供）", position = 2, required = true)
    private String partnerId;

    @ApiModelProperty(value = "商家门店号（在线支付需要提前定义）", position = 3, required = true)
    private String storeId;

    @ApiModelProperty(value = "商家POS机编号（可以使用固定值）", position = 4, required = true)
    private String stationId;

    @ApiModelProperty(value = "营业员编号（可以使用固定值）", position = 5, required = true)
    private String operatorId;

    @ApiModelProperty(value = "业务日期", position = 7)
    private String businessDate;

    @ApiModelProperty(value = "终端交易序号", position = 6, required = true)
    private String transId;

    @ApiModelProperty(value = "客户端code", position = 8, required = true)
    private Long clientCode;

}
