package cn.freemud.service.impl

import cn.freemud.adapter.ActivityAdapter
import cn.freemud.adapter.CouponAdapter
import cn.freemud.adapter.StoreItemAdapter
import cn.freemud.entities.dto.GetCouponDetailResponseDto
import cn.freemud.entities.dto.ProductBaseResponse
import cn.freemud.entities.dto.ProductInfosDto
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto
import cn.freemud.entities.dto.order.PackAmountConfig
import cn.freemud.entities.dto.product.CheckCartRequest
import cn.freemud.entities.dto.product.ValiadShopProductResponse
import cn.freemud.entities.dto.user.GetUserScoreUserDetailResponse
import cn.freemud.entities.vo.CartGoods
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo
import cn.freemud.handle.CommonFunctionHandle
import cn.freemud.service.ActivityService
import cn.freemud.service.CommonService
import cn.freemud.service.active.ActiveFactory
import cn.freemud.service.active.impl.PlatformActiveServiceImpl
import cn.freemud.service.impl.calculate.CalculationCommonService
import cn.freemud.service.impl.calculate.CalculationSharingCartService
import cn.freemud.service.impl.calculate.CalculationSharingDiscountService
import cn.freemud.service.impl.calculate.promotion.*
import cn.freemud.service.shoppingCart.ShoppingCartRelationFactory
import cn.freemud.service.shoppingCart.impl.PlatformShoppingCartRelationServiceImpl
import cn.freemud.service.thirdparty.ActivityClient
import cn.freemud.service.thirdparty.CouponOnlineClient
import cn.freemud.service.thirdparty.CustomerApplicationClient
import cn.freemud.service.thirdparty.ProductClient
import cn.freemud.utils.PromotionFactory
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import org.junit.runner.RunWith
import org.mockito.Mockito
import org.powermock.api.mockito.PowerMockito
import org.powermock.core.classloader.annotations.PrepareForTest
import org.powermock.modules.junit4.PowerMockRunner
import org.powermock.modules.junit4.PowerMockRunnerDelegate
import org.spockframework.runtime.Sputnik
import spock.lang.Specification
/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/4 16:56
 * @description : 
 */
@RunWith(PowerMockRunner.class)
@PowerMockRunnerDelegate(Sputnik.class)
@PrepareForTest(PromotionFactory.class)
class FishermanSpock extends Specification {
    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def activityAdapter = new ActivityAdapter()
    def couponAdapter = new CouponAdapter()
    def productServiceImpl = new ProductServiceImpl()
    def sharingDiscountService = new CalculationSharingDiscountService()
    def couponService = new CouponServiceImpl()
    def itemService = new ItemServiceImpl()
    def storeItemAdapter = new StoreItemAdapter()
    def defaultPromotionService = new DefaultPromotionService()
    def couponPromotionService = new CouponPromotionService()
    def buySendPromotionService = new BuySendPromotionService()
    def additionalPromotionService = new AdditionalPromotionService()
    def timeSalePromotionService = new TimeSalePromotionService()
    def setMealService = new SetMealServiceImpl()
    def customerScoreService = new CustomerScoreService()
    def xyDiscountService = new XyDiscountServiceImpl()
    def buyAndGiftsPromotionService = new BuyAndGiftsPromotionService()
    def materialPromotionService = new MaterialPromotionService()
    def fullPromotionService = new FullPromotionService()
    def sharingCartService = new CalculationSharingCartService()


    def assortmentSdkService = PowerMockito.mock(AssortmentSdkService)
    def customerInfoManager = PowerMockito.mock(AssortmentCustomerInfoManager.class)
    def productService = PowerMockito.mock(ProductServiceImpl.class)
    def productClient = PowerMockito.mock(ProductClient.class)
    def activityClient = PowerMockito.mock(ActivityClient.class)
    def couponOnlineClient = PowerMockito.mock(CouponOnlineClient.class)
    def commonService = PowerMockito.mock(CommonService.class)
    def activityService = PowerMockito.mock(ActivityService)
    def activeFactory = PowerMockito.mock(ActiveFactory)

    // 组装计算活动参数对象
    def calculationCommonService = new CalculationCommonService()
    def commonFunctionHandle = PowerMockito.mock(CommonFunctionHandle)
    def promotionSharingService = new CouponSharingService()
    def fullSharingService = new FullSharingService()
    def giftSharingService = new GiftSharingService()
    def additionSharingService = new AdditionSharingService()
    def scoreSharingService = new ScoreSharingService()
    def deliverySharingService = new DeliverySharingService()
    def buyOneGiveOneSendService = new BuyOneGiveOneSendService()
    def customScoreClient = PowerMockito.mock(CustomerApplicationClient)
    def shoppingCartRelationFactory = PowerMockito.mock(ShoppingCartRelationFactory)

    void setup() {
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
        shoppingCartNewServiceImpl.shoppingCartRelationFactory = shoppingCartRelationFactory
        shoppingCartNewServiceImpl.productService = productService
        shoppingCartNewServiceImpl.assortmentSdkService = assortmentSdkService
        shoppingCartNewServiceImpl.activityAdapter = activityAdapter
        shoppingCartNewServiceImpl.couponAdapter = couponAdapter
        shoppingCartNewServiceImpl.couponService = couponService
        shoppingCartNewServiceImpl.commonService = commonService
        shoppingCartNewServiceImpl.sharingCartService = sharingCartService
        // fisherman  测试过程中, 需要测试 新老算价需要自己 控制开关
        shoppingCartNewServiceImpl.newSharing = "{\"type\":1,\"grayList\":\"2581\",\"enable\":true}"
        shoppingCartNewServiceImpl.activityClient = activityClient
        shoppingCartNewServiceImpl.sharingDiscountService = sharingDiscountService
        productServiceImpl.productClient = productClient
        sharingDiscountService.activityClient = activityClient
        sharingDiscountService.couponService = couponService
        sharingDiscountService.commonService = commonService
        sharingDiscountService.activeFactory = activeFactory
        couponService.couponOnlineClient = couponOnlineClient
        couponService.commonService = commonService
        couponService.itemService = itemService
        couponService.storeItemClient = productClient
        itemService.storeItemAdapter = storeItemAdapter
        itemService.storeItemClient = productClient
        fullPromotionService.activityService = activityService
        // mock静态类
        PowerMockito.mockStatic(PromotionFactory.class)

        // 组装计算活动参数对象
        sharingCartService.calculationCommonService = calculationCommonService
        calculationCommonService.commonFunctionHandle = commonFunctionHandle
        sharingCartService.promotionSharingService = promotionSharingService
        promotionSharingService.assortmentSdkService = assortmentSdkService
        sharingCartService.fullSharingService = fullSharingService
        sharingCartService.giftSharingService = giftSharingService
        sharingCartService.additionSharingService = additionSharingService
        sharingCartService.scoreSharingService = scoreSharingService
        sharingCartService.deliverySharingService = deliverySharingService
        sharingCartService.buyOneGiveOneSendService = buyOneGiveOneSendService
        fullSharingService.activityService = activityService
        scoreSharingService.customScoreClient = customScoreClient
    }

    def "listCartGoods"() {
        given: "参数设置"
        def shoppingCartInfoRequestVo = JSON.parseObject("{\"activityCode\":\"\",\"appId\":\"wxa1f272347828dae8\",\"buyType\":0,\"cardCodes\":[\"5826900000012200001\"],\"channelType\":\"saas\",\"couponCode\":\"\",\"couponCodes\":[],\"enableSharing\":0,\"flag\":1,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2690\",\"reachStoreType\":4,\"receiveId\":\"\",\"sendGoods\":[],\"sessionId\":\"c0160864097837bd4aca54ed7537848f46bba70f\",\"shopId\":\"1001\",\"unChooseCouponCode\":\"\",\"useCustomerScore\":2,\"version\":\"2\"}"
                , ShoppingCartInfoRequestVo.class)

        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)

        //  saas:user:info:cart:goods:2690_1001_3653544968271672251
        def cartGoodsList = JSON.parseArray("[{\"addCartTime\":1654841967007,\"amount\":1,\"canUseCoupon\":1,\"cartGoodsUid\":\"ba1c5800-637c-4b72-bfc7-76da62d61c8c\",\"categoryName\":\"推荐\",\"classificationForeignName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1654841967007,\"customerCode\":\"hongdouximilu\",\"finalPrice\":1,\"foreignName\":\"\",\"goodsId\":\"219187388813086254\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"红豆西米露/大杯\",\"originalAmount\":1,\"originalMaterialAmount\":0,\"originalPrice\":1,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1631789025732.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"\",\"skuName\":\"红豆西米露/大杯\",\"spuForeignName\":\"\",\"spuId\":\"219187388813086254\",\"spuName\":\"红豆西米露/大杯\",\"stockLimit\":false,\"subForeignName\":\"\",\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"addCartTime\":1654850258889,\"amount\":0,\"canUseCoupon\":1,\"cartGoodsUid\":\"9a7b1c23-4347-48a3-a612-fe303a1cb23f\",\"couponCode\":\"88709608644979836830\",\"createTimeMili\":1654850258889,\"extra\":[],\"goodsId\":\"spq88709608644979836830\",\"goodsType\":7,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"originalAmount\":0,\"originalPrice\":0,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1631788957908.jpg\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"skuId\":\"219187474445045306\",\"spuId\":\"219187474445045306\",\"stockLimit\":true,\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]"
                , CartGoods.class)


        def checkCartRequest = new CheckCartRequest()
        checkCartRequest.setCartGoodsList(cartGoodsList)

        //     code.allDetails       "storelimit": 0,
        def responseDto = JSON.parseObject("{\"details\":[{\"storelimit\":0,\"active\":{\"activeCode\":\"M1654656180041548\",\"activeDesc\":\"场通用”或“仅限烟酒类使用”\",\"activeName\":\"晓航测试券\",\"createDate\":\"2022-06-08 10:43:00\",\"createUser\":\"晓航\",\"endDate\":\"2032-06-07 10:42:59\",\"endString\":\"2032-06-07 10:42:59\",\"inventory\":0,\"lastEditDate\":\"2022-06-08 10:43:00\",\"lastEditUser\":\"\",\"maxDiscount\":0,\"maxRedeemTimes\":1,\"minAmount\":0,\"partnerId\":\"2690\",\"startDate\":\"2022-06-07 10:42:59\",\"startString\":\"2022-06-07 10:42:59\",\"state\":1,\"type\":0},\"activeCode\":\"M1654656180041548\",\"activeProduct\":[{\"activeId\":125781717,\"amount\":1,\"paid\":0,\"priceDiscount\":0.00,\"priceOriginal\":0.00,\"productId\":1234567,\"productIdPartner\":\"219187474445045306\",\"remain\":0}],\"activeProductSetting\":[],\"activeRedeemTimeIntervalList\":[],\"activeRestrictionVOS\":[],\"code\":\"88709608644979836830\",\"couponProductList\":[{\"activeProductId\":182981823,\"amount\":1,\"amountleft\":1,\"couponid\":960864498020545,\"createdate\":1654850379871,\"createuser\":\"api\",\"id\":0,\"lasteditdate\":1654850379871,\"lastedituser\":\"api\",\"merchantproductid\":\"219187474445045306\",\"paid\":0.00,\"priceDiscount\":0.00,\"productname\":\"玫瑰豉油鸡\",\"redeemAmount\":0,\"remain\":0}],\"create_time\":\"2022-06-08 10:47:39\",\"minAmount\":\"0\",\"sendReason\":\"手动送券，晓航，18868926846\",\"status\":0,\"storeChannelLimit\":0,\"storeLimitLevel\":1,\"subType\":0,\"title\":\"晓航测试券\",\"today_available_times\":1,\"total_available_times\":1,\"type\":0,\"valid_ends\":\"2022-06-30 23:59:59\",\"valid_start\":\"2022-06-08 00:00:00\"}],\"errors\":[],\"result\":1,\"statusCode\":0,\"ver\":1}"
                , GetCouponDetailResponseDto.class)

        // /Shop/ListProductInfoByIdList
        def productInfosDto = JSON.parseObject("{\"data\":{\"count\":1,\"products\":[{\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2690\",\"customerCode\":\"20210916\",\"finalPrice\":1000,\"foreignName\":\"\",\"isSkuProduct\":0,\"labelNames\":[],\"linkedId\":\"\",\"maxNum\":0,\"minNum\":0,\"name\":\"玫瑰豉油鸡\",\"originalPrice\":1000,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1631788957908.jpg\",\"pid\":\"219187474445045306\",\"pknumber\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1631788957908.jpg\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"remark\":\"\",\"sellTimeList\":[],\"sequence\":0,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"status\":2,\"stock\":9999,\"stockLimit\":1,\"tax\":0.01,\"taxId\":\"\",\"type\":1,\"unit\":\"\",\"updateStatus\":0,\"valid\":true,\"version\":0,\"weight\":0.0,\"weightType\":0}]},\"errcode\":100,\"errmsg\":\"成功\"}"
                , ProductInfosDto.class)

        // Shop/ValidateShopProduct
        def valiadProductResponse = JSON.parseObject("{\"data\":{\"failureList\":[],\"successList\":[{\"code\":0,\"productType\":{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2690\",\"customerCode\":\"20210916\",\"finalPrice\":1000,\"foreignName\":\"\",\"isDishware\":0,\"isSkuProduct\":0,\"linkedId\":\"\",\"memberDiscount\":0,\"name\":\"玫瑰豉油鸡\",\"openMemberDiscount\":0,\"originalPrice\":1000,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1631788957908.jpg\",\"pid\":\"219187474445045306\",\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCode\":\"202109\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1631788957908.jpg\"}],\"rawMaterial\":\"\",\"riseSell\":1,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"specification\":\"\",\"status\":2,\"stock\":9999,\"stockLimit\":1,\"tax\":0.01,\"taxId\":\"\",\"type\":1,\"unit\":\"\",\"weight\":0.0,\"weightType\":0},\"skuId\":\"219187474445045306\",\"spuId\":\"219187474445045306\",\"uuid\":\"4905bcae-12b8-426f-94c7-8fda93a99914\"}]},\"errcode\":100,\"errmsg\":\"获取门店必选分类商品成功\"}"
                , new TypeReference<ProductBaseResponse<ValiadShopProductResponse>>() {})

        def platformActiveServiceImpl = new PlatformActiveServiceImpl()

        // promotioncenter/calculateservice/discount/sharing
        def sharingDiscountResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":{\"apportionGoods\":[],\"couponDiscounts\":[],\"discounts\":[],\"distributionFee\":0,\"goods\":[{\"actualGoodsNumber\":0,\"cartGoodType\":0,\"cartGoodsUid\":\"9a7b1c23-4347-48a3-a612-fe303a1cb23f\",\"discountAmount\":0,\"discounts\":[],\"gift\":false,\"goodsId\":\"219187474445045306\",\"goodsQuantity\":1,\"meal\":false,\"nowPrice\":1000,\"originalPrice\":1000,\"realAmount\":1000},{\"actualGoodsNumber\":0,\"cartGoodType\":0,\"cartGoodsUid\":\"ba1c5800-637c-4b72-bfc7-76da62d61c8c\",\"discountAmount\":0,\"discounts\":[],\"gift\":false,\"goodsId\":\"219187388813086254\",\"goodsQuantity\":1,\"meal\":false,\"nowPrice\":1,\"originalPrice\":1,\"realAmount\":1}],\"isScoreLimit\":0,\"nightDistributionFee\":0,\"originalTotalAmount\":1001,\"stocks\":[],\"totalAmount\":1001,\"totalDiscountAmount\":0,\"v3Promotion\":true},\"statusCode\":\"100\",\"ver\":1}"
                , new TypeReference<ActivityCalculationDiscountResponseDto>() {})

        def packAmountByStoreConfig = new PackAmountConfig()
        packAmountByStoreConfig.setNewPackAmount(0L)


        // 满减里面的活动查询    /activity/query
        def activityQueryResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":[{\"activityCode\":\"MZSP2022051911010449819\",\"activityDesc\":\"description\",\"activityName\":\"晓航测试满赠活动\",\"activityStatus\":1,\"activitySubType\":1,\"activityType\":230,\"auditStatus\":1,\"benefits\":[{\"benefitName\":\"晓航测试满赠活动\",\"benefitSeq\":1,\"sendGoodsList\":[{\"goodsCode\":\"215806824348227645\",\"goodsId\":\"215806824348227645\",\"goodsName\":\"柚子的汉堡\",\"originalPrice\":1000,\"productType\":1,\"quantityLimit\":3,\"sendCoupon\":false,\"sendNumber\":3,\"serialNumber\":99}],\"thresholdAmount\":201}],\"couponType\":0,\"createTime\":\"1652929305000\",\"delayTimes\":0,\"delayUnit\":\"\",\"discountTimes\":0,\"endTime\":1655567999000,\"isShared\":1,\"maxMoney\":0,\"minNum\":0,\"partnerCode\":\"2690\",\"priority\":68,\"startTime\":1652889600000,\"totalTimes\":0,\"updateTime\":\"1653292419000\"}],\"statusCode\":\"100\",\"ver\":1}"
                , new TypeReference<ActivityQueryResponseDto>() {})

        //  /user/scoreUseDetail
        def userScoreUseDetail = JSON.parseObject("{\"code\":\"100\",\"message\":\"success\",\"result\":{\"currentScore\":9998,\"getReduceScoreLimit\":1,\"overlayOffers\":0,\"reduceAmount\":1000,\"reducePriceLimit\":0,\"scoreReduceRate\":\"1:1\",\"scoreReduceState\":true,\"scoreState\":1,\"useScore\":10},\"ver\":\"1\"}"
                , new TypeReference<GetUserScoreUserDetailResponse>() {})


        and: "调三方反馈参数 为自己的参数对象 "
        Mockito.when(customerInfoManager.getCustomerInfoByObject(Mockito.any())).thenReturn(customerInfoVo)
        Mockito.when(assortmentSdkService.getShoppingCart(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(cartGoodsList)
        Mockito.when(assortmentSdkService.checkShoppingCartSdk(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(checkCartRequest)

        Mockito.when(couponOnlineClient.getCouponDetails(Mockito.any())).thenReturn(responseDto)
        Mockito.when(productClient.listProductInfos(Mockito.any())).thenReturn(productInfosDto)
        Mockito.when(productClient.validateShopProduct(Mockito.any())).thenReturn(valiadProductResponse)
        Mockito.when(commonService.getOrgIdsForCoupon("", "")).thenReturn(null)
        Mockito.when(activeFactory.getBuildChooseGoodsService(Mockito.any())).thenReturn(platformActiveServiceImpl)
        Mockito.when(activityClient.calculationSharingDiscount(Mockito.any())).thenReturn(sharingDiscountResponseDto)
        Mockito.when(commonFunctionHandle.getPackAmountByStoreConfig(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(packAmountByStoreConfig)
        Mockito.when(assortmentSdkService.setShoppingCart(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(null)

        // 满减活动里面的 查询
        Mockito.when(activityService.queryActivityByType(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(activityQueryResponseDto)
        Mockito.when(customScoreClient.getUserScoreUseDetail(Mockito.any())).thenReturn(userScoreUseDetail)
        Mockito.when(shoppingCartRelationFactory.getBuildShoppingCartGoodsResponseService(Mockito.any())).thenReturn(new PlatformShoppingCartRelationServiceImpl())


        when: "调用方法逻辑"
        def response = shoppingCartNewServiceImpl.getGoodsList(shoppingCartInfoRequestVo)
        then: "验证 返回结果"
        with(response) {
            code == "100"
            message == "success"
        }

    }
}
