package cn.freemud.entities.dto.pay;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

@Data
@ToString
public class MultiQueryRequest {

    /**
     * 商户编号（由非码提供）
     */
    @JSONField(name = "partner_id")
    @JsonProperty("partner_id")
    private Integer partnerId;
    
    /**
     * 商家门店号（在线支付需要提前定义）
     */
    @JSONField(name = "store_id")
    @JsonProperty("store_id")
    private String storeId;

    /**
     * 开启渠道端查询,默认不开启
     */
    @ApiModelProperty(value = "开启渠道端查询,默认不开启")
    @JSONField(name = "enable_platform_data_query")
    @JsonProperty("enable_platform_data_query")
    private Boolean enablePlatformDataQuery = false;

    @ApiModelProperty(value = "交易流水号(支付标识)")
    @JSONField(name = "fm_trade_no")
    @JsonProperty("fm_trade_no")
    private String fmTradeNo;

    /**
     * 外部交易流水号，由上游系统生成，需保证唯一(支付标识)
     */
    @ApiModelProperty(value = "外部交易流水号，由上游系统生成，需保证唯一(支付标识)", required = true)
    @JSONField(name = "out_order_no")
    @JsonProperty("out_order_no")
    @NotEmpty(message = "外部交易流水号不能为空")
    private String outOrderNo;
    
}
