/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderProductAddInfoDto
 * @Package com.freemud.sdk.api.assortment.request.order
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/9 17:25
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.vo.ProductGroupVo;
import lombok.Data;

import java.util.List;

@Data
public class OrderProductAddInfoDto extends BaseConfig {

    /**
     * 属性名称 多糖/冷/常温
     */
    private String attributeNames;

    /**
     * 是否是套餐内固定商品
     */
    private Boolean isFixedProduct;

    /**
     * 第三方商品规格ID
     */
    private String thirdProductSpecId;

    /**
     * 第三方商品属性ID
     */
    private String thirdProductPropertyId;

    /**
     * 第三方品类id
     */
    private String thirdCategoryId;

    /** 商品组 **/
    private List<ProductGroupVo> productGroupList;

    /** 是否主食 **/
    private Integer stapleFood;

    /**
     * 商品绑定的券活动（买券虚拟订单才有）
     */
    private List<ProductBindingCouponType> productBindingCoupons;

    /**
     * 商品统计分类编号
     */
    private String thirdCensusCategoryId;

    private double tax;

    private String taxId;
}
