package cn.freemud.enums;

public enum BizTypeEnum {

    APP_COUPON(6, "APP买券"),

    APP_PRO(1, "未知（目前暂不支持）,后续可能预留给正常商品");

    private Integer bizType;
    private String desc;

    BizTypeEnum(Integer bizType, String desc) {
        this.bizType = bizType;
        this.desc = desc;
    }

    public static cn.freemud.enums.BizTypeEnum getByCode(Integer code) {
        for (cn.freemud.enums.BizTypeEnum payType : values()) {
            if (payType.getBizType().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}