package cn.freemud.manager;

import cn.freemud.adapter.OrderAdapter;
import cn.freemud.entities.db.Partner;
import cn.freemud.enums.OrderTackCodeFactory;
import cn.freemud.service.impl.StoreServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.function.Function;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PartnerManagerTest
 * @Package cn.freemud.manager
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/22 16:32
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
public class TackCodeManagerTest {

    @Autowired
    private OrderTackCodeManager orderTackCodeManager;

    Function<Integer,String> function;

    @Test
    public void selectTackCode(){
        String code = orderTackCodeManager.generateTackCode(5,"1864","1000221",null, OrderTackCodeFactory.getByOrderClient("2").getGenerateTackCodeFunc());

        log.debug("code=="+code);
    }
}
