package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import org.springframework.stereotype.Service;

@Service
public class PlatformAddGoodsService extends AbstractAddGoodsService {

    private static Integer MAX_SHOP_LENGTH = 32;

    @Override
    public BaseResponse checkCustomParams(BaseAddGoodsBO baseRequestDTO) {
        if (baseRequestDTO.getShopId().length() > MAX_SHOP_LENGTH){
            throw new ServiceException(ResponseResult.SHOPPING_CART_SHOP_ID_NOT_EMPTY);
        }

        return null;
    }

    @Override
    public BaseResponse checkCustomBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        return null;
    }


}
