package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.constant.ResponseConstant;
import cn.freemud.demo.entities.ResponseBuilder;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.manager.AssortmentSdkManager;
import cn.freemud.demo.manager.CustomerManager;
import cn.freemud.entities.vo.CustomerInfoVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.impl.AssortmentSdkService;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

public abstract class AbstractAddGoodsService implements AddGoodsService {

    @Autowired
    private CustomerManager customerManager;

    @Autowired
    private AssortmentSdkManager assortmentSdkManager;


    /**
     * 组织订单的创建流程
     *
     * @return
     */
    public final BaseAddGoodsBO addGoods(BaseAddGoodsBO addGoodsBO) {
        // 基本参数校验
        this.checkParams(addGoodsBO);

        // 获取购物车和加车商品信息
        this.getShoppingCartInfo(addGoodsBO);

        // 业务校验,例如商品数量库存之类的信息
        this.checkBusinessRules(addGoodsBO);

        // 添加商品到购物车
        this.addGoodsToShoppingCart(addGoodsBO);

        // 计算费用,例如配送费
        this.calCost(addGoodsBO);

        // 提示语设置,例如满减信息
        this.setMessage(addGoodsBO);

        // 拼装返回体
        this.buildResponse(addGoodsBO);

        return addGoodsBO;
    }

    public final BaseResponse checkCommParams(BaseAddGoodsBO baseRequestDTO) {

        if (StringUtils.isEmpty(baseRequestDTO.getShopId())){
            throw new ServiceException(ResponseResult.SHOPPING_CART_SHOP_ID_NOT_EMPTY);
        }

        return ResponseBuilder.success();
    }

    public final BaseResponse checkCommBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        return null;
    }

    public final BaseResponse calCommCost(BaseAddGoodsBO baseRequestDTO) {
        return null;
    }

    public final BaseResponse setCommMessage(BaseAddGoodsBO baseRequestDTO) {
        return null;
    }

    public final BaseResponse buildCommResponse(BaseAddGoodsBO baseRequestDTO) {
        return null;
    }

    /**
     * 计算不在促销计算范围里的费用
     * @param addGoodsBO
     * @return
     */
    public final BaseResponse calCost(BaseAddGoodsBO addGoodsBO) {
        BaseResponse commonBaseResponse = this.calCommCost(addGoodsBO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.calCustomCost(addGoodsBO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }

    /**
     * 设置提示语
     * @param addGoodsBO
     * @return
     */
    public final BaseResponse setMessage(BaseAddGoodsBO addGoodsBO) {
        BaseResponse commonBaseResponse = this.setCommMessage(addGoodsBO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.setCustomMessage(addGoodsBO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }


    /**
     * 请求基本参数校验
     * @return
     */
    public final BaseResponse checkParams(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.checkCustomParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }

    /**
     * 1. 获取加车的商品信息
     * 2. 获取购物车的商品信息
     *
     * @return
     */
    public final BaseResponse getShoppingCartInfo(BaseAddGoodsBO baseRequestBO) {

        String userId = customerManager.getUserId(baseRequestBO.getSessionId());
        baseRequestBO.setUserId(userId);

        ProductBO productBO = assortmentSdkManager.getProductsInfoSdk(baseRequestBO.getPartnerId(), baseRequestBO.getShopId(), baseRequestBO.getAddGoods().getSpuId(), null);
        baseRequestBO.setAddGoods(productBO);



        return ResponseBuilder.success();
    }

    /**
     * 具体业务逻辑校验, 例如商品数量,库存等校验
     *
     * @return
     */
    public final BaseResponse checkBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommBusinessRules(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.checkCustomBusinessRules(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }


    /**
     * 添加商品到购物车,并重新设置购物车
     *
     * @return
     */
    public final BaseResponse addGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommBusinessRules(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.checkCustomBusinessRules(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }

    /**
     * 封装返回参数
     *
     * @return
     */
    public final BaseResponse buildResponse(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.buildCommResponse(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.buildCustomResponse(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }



}
