package cn.freemud.demo.entities.dto.goods.add;

import cn.freemud.demo.entities.dto.BaseRequestDTO;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ComboxGoodsRequestVo;
import cn.freemud.entities.vo.MaterialRequestVo;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
public class AddGoodsRequestDTO extends BaseRequestDTO {

    /**
     * 拼单发起人userId（拼单）
     */
    private String createCollageUserId;

    /**
     * 购物车版本号（拼单）
     */
    private Integer carVer;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;

    private String version;

    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialRequestVo> productMaterialList;
    private String appType;

    private String tableNumber;
    /**
     * 数量
     */
    private Integer qty;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;


}
