package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.GetPaidRuleRequestDto;
import cn.freemud.entities.dto.GetPaidRuleResponseDto;
import cn.freemud.entities.dto.user.GetSessionUserInfoDto;
import cn.freemud.entities.vo.CustomerInfoVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CustomerApplicationClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/5/27 14:32
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@FeignClient(name = "customer-application-service",url = "${saas.newcustomerclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerApplicationClient {
    @PostMapping(value = "/membercard/getPaidRule")
    BaseResponse<GetPaidRuleResponseDto> getPaidRule(GetPaidRuleRequestDto getPaidRuleRequestDto);

    @PostMapping(value = "/user/getSessionUserInfo")
    BaseResponse<CustomerInfoVo>getSessionUserInfo(GetSessionUserInfoDto getSessionUserInfoDto);
}
