package cn.freemud.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.GetMemberListRequestDto;
import cn.freemud.entities.dto.GetMemberListResponseDto;
import cn.freemud.entities.vo.ShoppingCartClearToolsRequestVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.ShoppingCartToolsService;
import cn.freemud.service.thirdparty.MemberToolsClient;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.sdk.api.assortment.shoppingcart.service.ShoppingCartBaseService;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ShoppingCartToolsServiceImpl implements ShoppingCartToolsService {

    static final Logger logger = LoggerFactory.getLogger(ShoppingCartToolsServiceImpl.class);


    @Autowired
    private MemberToolsClient memberToolsClient;
    @Autowired
    private ShoppingCartBaseService shoppingCartBaseService;
    @Autowired
    private AssortmentSdkService assortmentSdkService;

    /**
     * @notes 清空购物车
     * @param shoppingCartClearToolsRequestVo
     * @return
     */
    @Override
    public BaseResponse clear(ShoppingCartClearToolsRequestVo shoppingCartClearToolsRequestVo) {
        GetMemberListResponseDto getMemberListResponseDto = getMemberListResponseDto(shoppingCartClearToolsRequestVo);
        if (!ResponseResult.SUCCESS.getCode().equals(getMemberListResponseDto.getCode())) {
            return ResponseUtil.error(ResponseResult.SYSTEM_ERROR, "查询会员信息返回失败");
        }
        String mobile  = shoppingCartClearToolsRequestVo.getMobile();
        if(0 == getMemberListResponseDto.getData().getTotalCount()){
            return ResponseUtil.error(ResponseResult.SUCCESS,mobile+" 用户下购物车数据为空,无需删除");
        }
        String partnerId = shoppingCartClearToolsRequestVo.getPartnerId();
        String storeId = shoppingCartClearToolsRequestVo.getShopId();
        StringBuffer stringBuffer = new StringBuffer();
        String memberId = "";
        List<String> userIds = getUserIds(getMemberListResponseDto);
        for (String userId : userIds) {
            try {
                // 构造请求参数，进行清空购物车
                memberId = userId;
                com.freemud.sdk.api.assortment.shoppingcart.domain.CartParamDto cartParamDto = assortmentSdkService.getCartParamDto(partnerId, storeId, userId);
                shoppingCartBaseService.clear(cartParamDto, LogThreadLocal.getTrackingNo());
                packageMessage( stringBuffer,partnerId,storeId,mobile,memberId, "成功");
            }catch (Exception var9) {
                logger.error(("清空购物车失败:"+"商户号:"+partnerId + "，门店号:"+storeId+"，手机号:"+mobile+"，会员号:"+memberId), var9);
                packageMessage( stringBuffer,partnerId,storeId,mobile,memberId, "失败");
                continue;
            }
        }
        return ResponseUtil.success(stringBuffer);
    }

    private GetMemberListResponseDto getMemberListResponseDto(ShoppingCartClearToolsRequestVo shoppingCartClearToolsRequestVo){
        GetMemberListRequestDto getMemberListRequestDto = new GetMemberListRequestDto(shoppingCartClearToolsRequestVo.getPartnerId(),shoppingCartClearToolsRequestVo.getMobile(),1,999);
        GetMemberListResponseDto getMemberListResponseDto = memberToolsClient.getMemberList(getMemberListRequestDto);
        return getMemberListResponseDto;
    }

    private List<String> getUserIds(GetMemberListResponseDto getMemberListResponseDto){
        return getMemberListResponseDto.getData().getMemberList().stream().map(GetMemberListResponseDto.ResultBean.Member::getMemberId).collect(Collectors.toList());
    }

    private void packageMessage(StringBuffer stringBuffer,String partnerId,String storeId,String mobile,String memberId,String message){
        stringBuffer.append("商户号:"+partnerId + "，门店号:"+storeId+"，手机号:"+mobile+"，会员号:"+memberId+" 清除购物车:"+message+";");
    }
}
