package com.freemud.application.sdk.api.ordercenter.enums;

public enum CashTypeEnum {

    OTHER("10", "其他"),
    HLM("50", "汇来米"),
    SQB("51", "收钱吧"),
    CASH("52", "现金");


    private String code;
    private String desc;

    CashTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CashTypeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (CashTypeEnum cashTypeEnum : values()) {
            if (cashTypeEnum.getCode().equals(code)) {
                return cashTypeEnum;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
