/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CustomerExtendClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.management.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.constant.ResponseCodeConstant;
import cn.freemud.management.entities.dto.request.customer.ForbiddenCardCodeRequest;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "customer-extend-service", url = "${saas.customerextendclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerMcCafeClient {

    @PostMapping(value = "/customerextendservice/qujia/forbiddenCardCode")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, printInfoLog = true)
    BaseResponse forbiddenCardCodeForQujia(@RequestBody ForbiddenCardCodeRequest request);
}
