package cn.freemud.management.service.handle;

import cn.freemud.base.util.DateUtil;
import cn.freemud.management.adapter.OrderCancelReqAdapter;
import cn.freemud.management.adapter.PaymentSdkAdapter;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.request.pay.PayRefundRequestDto;
import cn.freemud.management.entities.dto.request.pay.PaymentQueryOrderRequestDto;
import cn.freemud.management.entities.dto.response.pay.OrderRefundResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundData;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.entities.dto.response.pay.PaymentQueryOrderResponseDto;
import cn.freemud.management.enums.OrderCostType;
import cn.freemud.management.enums.PaymentRefundStatus;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.thirdparty.OMSPaymentClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.CashTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.enums.PayMethodEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesOrderResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderCostResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.application.sdk.api.ordercenter.util.LogUtil;
import com.freemud.application.sdk.api.util.ResponseUtils;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PaymentService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 10:45
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class PaymentHandle {

    private static final String SUCCESS = "100";
    public static final Integer SUCCESS_RESPONSE_CODE_INT = 100;
    public static final Integer SUCCESS_RESPONSE_101_CODE_INT = 101;

    public static final Integer REFUND_RESPONSE_CODE = 8200305;


    @Autowired
    private PaymentSdkAdapter paymentSdkAdapter;
    @Autowired
    private OrderSdkService orderSdkService;
    @Autowired
    private MultiRefundService multiRefundService;
    @Autowired
    private OMSPaymentClient paymentNewClient;
    @Autowired
    private LogUtil logUtil;

    /**
     * 入参使用新订单结构，不推荐在用V1的OrderBean
     * @see this#getCommonPayRefundResponse(OrderInfoReqs, String)
     */
    @Deprecated
    public PayRefundResponse getCommonPayRefundResponse(OrderManagerRequest request, OrderBeanV1 orderBean) {
        PayRefundResponse refundResponse;
        try {
            // 最大可退金额 = 订单实付总额 - 开通会员卡金额 退款的时候会员卡已经开通了，所以开卡费不可退
            OrderCostResp openMemberCardCost = null;
            if (CollectionUtils.isNotEmpty(orderBean.getOrderCostDetailList())) {
                openMemberCardCost = orderBean.getOrderCostDetailList().stream().filter(c -> Objects.equals(c.getCostType(), OrderCostType.OPEN_MEMBER_CARD_FEE.getType())).findFirst().orElse(null);
            }
            // 最大可退金额 = 订单实付总额 - 开通会员卡金额 退款的时候会员卡已经开通了，所以开卡费不可退
            BigDecimal maxRefundAmount = openMemberCardCost != null ? new BigDecimal(orderBean.getAmount()).subtract(openMemberCardCost.getCostAmount()) : new BigDecimal(orderBean.getAmount());
            BigDecimal refundAmount = maxRefundAmount;
            AfterSalesOrderResp afterSalesOrder = getAfterSalesOrder(orderBean.getCompanyId(), orderBean.getOid());
            if (afterSalesOrder != null) {
                refundAmount = new BigDecimal(afterSalesOrder.getActualAmount());
            }
            //订单支付明细表新saas都会存数据，ka,pass商户需要兼容
            PayRefundResponse multiRefundResponse = multiRefundService.multiRefund(orderBean.getCompanyId(), orderBean.getShopId(),
                    orderBean.getOid(), refundAmount, orderBean.getOrderPayItem(),Integer.parseInt(orderBean.getOrderClient()));
            if (multiRefundResponse != null) {
                refundResponse = multiRefundResponse;
            }else {
                OrderExtendedReq extended = orderBean.getOrderExtended();
                if (StringUtils.isNotBlank(extended.getAgentPayerId()) && !Objects.equals(extended.getAgentPayerId(), orderBean.getUserId())) {
                    OrderExtInfoDto ext = JSON.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);
                    //代付人信息不为空  并且和订单创建人不一样，表示代付单   payment/application/agentRefund
                    refundResponse = multiRefundService.agentPayRefund(orderBean.getCompanyId(), orderBean.getShopId(), orderBean.getOid(), refundAmount, ext.getPayTransId());
                } else {
                    //正常订单现金退款  paymentcenter/refund
                    PayRefundRequestDto req = paymentSdkAdapter.getOrderRefundRequest(orderBean.getCompanyId(), orderBean.getShopId(),
                            orderBean.getOid(), refundAmount, orderBean.getPayVoucher(), orderBean.getExtInfo(), request.getReason());
                    // 抖音订单，退款时需要传递商品信息
                    if (OrderClientType.TIKTOKPAY.getIndex().toString().equals(orderBean.getOrderClient())) {
                        Map<String, String> extParam = new HashMap<>();
                        OrderExtInfoDto ext = JSON.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);
                        extParam.put("tt_goods", ext.getTtCouponIds());
                        extParam.put("tt_oid", orderBean.getOid());
                        req.setExtendParams(extParam);
                    }
                    refundResponse = this.payRefund(req);
                }
            }
            boolean partRefund = !Objects.equals(maxRefundAmount.compareTo(refundAmount), 0);
            if (afterSalesOrder != null) {
                refundResponse.setPartRefund(partRefund && afterSalesOrder.getIsPartRefund());
            } else {
                refundResponse.setPartRefund(partRefund);
            }
        } catch (OrderServiceException orderEx) {
            ResponseResult result = orderEx.getResult();
            refundResponse = new PayRefundResponse();
            refundResponse.setPayRefundStatus(PayRefundStatus.COMPATIBILITY_STATUS);
            refundResponse.setMessage(result.getMessage());
            refundResponse.setResult(result);
            return refundResponse;
        } catch (Exception e) {
            ErrorLog.errorConvertJson(this.getClass(), e.getMessage(), e);
            refundResponse = new PayRefundResponse();
            refundResponse.setPayRefundStatus(PayRefundStatus.COMPATIBILITY_STATUS);
            refundResponse.setMessage("请稍后再试！");
            refundResponse.setResult(ResponseResult.SYSTEM_ERROR);
            return refundResponse;
        }
        return refundResponse;
    }

    /**
     * 点餐订单退款入口
     * 支付退款，包含纯现金，代付，混合支付
     *
     * @param order 退款订单信息
     * @param reason 退款原因
     * @return
     */
    public PayRefundResponse getCommonPayRefundResponse(OrderInfoReqs order, String reason) {
        PayRefundResponse refundResponse;
        try {
            // 最大可退金额 = 订单实付总额 - 开通会员卡金额 退款的时候会员卡已经开通了，所以开卡费不可退
            OrderCostResp openMemberCardCost = null;
            if (CollectionUtils.isNotEmpty(order.getOrderCostDetailList())) {
                openMemberCardCost = order.getOrderCostDetailList().stream().filter(c -> Objects.equals(c.getCostType(), OrderCostType.OPEN_MEMBER_CARD_FEE.getType())).findFirst().orElse(null);
            }
            BigDecimal maxRefundAmount = openMemberCardCost != null ? order.getSettlementAmount().subtract(openMemberCardCost.getCostAmount()) : order.getSettlementAmount();
            BigDecimal refundAmount = maxRefundAmount;
            AfterSalesOrderResp afterSalesOrder = getAfterSalesOrder(order.getPartnerId(), order.getOrderCode());
            if (afterSalesOrder != null) {
                refundAmount = new BigDecimal(afterSalesOrder.getActualAmount());
            }

            PayRefundResponse multiRefundResponse = multiRefundService.multiRefund(order.getPartnerId(), order.getStoreId(),
                    order.getOrderCode(), refundAmount, order.getOrderPayItemCreateReqList(),order.getOrderClient());
            if (multiRefundResponse != null) {
                //  payment/application/refund
                refundResponse = multiRefundResponse;
                refundResponse.setRefundAmount(refundAmount);
            } else {
                OrderExtendedReq extended = order.getOrderExtended();
                if (StringUtils.isNotBlank(extended.getAgentPayerId()) && !Objects.equals(extended.getAgentPayerId(), order.getUserId())) {
                    OrderExtInfoDto ext = JSON.parseObject(order.getExtInfo(), OrderExtInfoDto.class);
                    //代付人信息不为空  并且和订单创建人不一样，表示代付单   payment/application/agentRefund
                    refundResponse = multiRefundService.agentPayRefund(order.getPartnerId(), order.getStoreId(), order.getOrderCode(), refundAmount, ext.getPayTransId());
                } else {
                    //正常订单现金退款  paymentcenter/refund
                    PayRefundRequestDto req = paymentSdkAdapter.getOrderRefundRequest(order.getPartnerId(), order.getStoreId(),
                            order.getOrderCode(), refundAmount, order.getPayRequestNo(), order.getExtInfo(), reason);
                    // 抖音订单，退款时需要传递商品信息
                    if (OrderClientType.TIKTOKPAY.getIndex().equals(order.getOrderClient())) {
                        OrderExtInfoDto ext = JSON.parseObject(order.getExtInfo(), OrderExtInfoDto.class);
                        Map<String, String> extParam = new HashMap<>();
                        extParam.put("tt_goods", ext.getTtCouponIds());
                        extParam.put("tt_oid", order.getOrderCode());
                        req.setExtendParams(extParam);
                    }
                    refundResponse = this.payRefund(req);
                }
            }
            boolean partRefund = !Objects.equals(maxRefundAmount.compareTo(refundAmount), 0);
            if (afterSalesOrder != null) {
                refundResponse.setPartRefund(partRefund && afterSalesOrder.getIsPartRefund());
            } else {
                refundResponse.setPartRefund(partRefund);
            }
            refundResponse.setRefundAmount(refundAmount);
        } catch (OrderServiceException orderEx) {
            ResponseResult result = orderEx.getResult();
            refundResponse = new PayRefundResponse();
            refundResponse.setPayRefundStatus(PayRefundStatus.COMPATIBILITY_STATUS);
            refundResponse.setMessage(result.getMessage());
            refundResponse.setResult(result);
            return refundResponse;
        } catch (Throwable e) {
            ErrorLog.errorConvertJson(this.getClass(), e.getMessage(), e);
            refundResponse = new PayRefundResponse();
            refundResponse.setPayRefundStatus(PayRefundStatus.COMPATIBILITY_STATUS);
            refundResponse.setMessage("请稍后再试！");
            refundResponse.setResult(ResponseResult.SYSTEM_ERROR);
            return refundResponse;
        }
        return refundResponse;
    }

    /**
     * 纯现金支付退款，非代付和混合支付退款
     *
     * @param refundReq    退款请求
     * @return 退款结果
     */
    private PayRefundResponse payRefund(PayRefundRequestDto refundReq) {
        PayRefundStatus refundStatus = PayRefundStatus.SUCCESS;
        if (refundReq.getRefundAmount() <= 0) {
            return handlePayRefundResponse(refundStatus, refundReq.getRefundId());
        }
        BaseResponse<OrderRefundResponse> orderRefundResponse = this.orderPayRefund(refundReq);
        String message = null;
        List<PayRefundResponse.PayRefundItem> refundItemList = new ArrayList<>();
        if (orderRefundResponse == null) {
            refundStatus = PayRefundStatus.RUNNING;
        } else {
            refundStatus = this.getFinalRefundStatus(Integer.valueOf(orderRefundResponse.getCode()));
            message = orderRefundResponse.getMessage();
            if (orderRefundResponse.getData() != null) {
                refundItemList.add(OrderCancelReqAdapter.convert(orderRefundResponse.getData()));
            }
        }
        PayRefundResponse payRefundResponse = handlePayRefundResponse(refundStatus, refundReq.getRefundId());
        payRefundResponse.setPayRefundItemList(refundItemList);
        if (message != null) {
            payRefundResponse.setMessage(message);
        }
        return payRefundResponse;
    }

    private PayRefundStatus getFinalRefundStatus(Integer resultCode) {
        return PayRefundStatus.getByPayResultCode(resultCode);
    }


    /**
     * 查询退款配置
     */
    private PayRefundRequestDto queryWxAppStore(BaseResponse<PaymentQueryOrderResponseDto> payQueryOrderResponse, PayRefundRequestDto refundRequest) {
        String payCode = null;
        if (Objects.equals(payQueryOrderResponse.getCode(), "100") && payQueryOrderResponse.getData() != null) {
            refundRequest.setTotalAmount((payQueryOrderResponse.getData()).getAmount());
            payCode = payQueryOrderResponse.getCode();
        }

        if (refundRequest.getTotalAmount() == null || refundRequest.getTotalAmount() == 0L) {
            refundRequest.setTotalAmount(refundRequest.getRefundAmount());
        }
//        AssortmentOpenPlatformIappWxappStore wxAppStore = this.assortmentOpenPlatformIappWxappStoreManager.selectWxappStoreByWxAppIdAndStoreId(refundRequest.getAppId(), refundRequest.getStoreId(), payCode);
        PayRefundRequestDto request = new PayRefundRequestDto();
        request.setStoreId(refundRequest.getStoreId());
        request.setStationId(refundRequest.getStationId());
        request.setOperatorId(refundRequest.getOperatorId());
        request.setTransId(refundRequest.getOrgTransId());
        request.setBusinessDate(refundRequest.getBusinessDate());
        request.setFmId(refundRequest.getOrgPayFmId());
        request.setTotalAmount(refundRequest.getTotalAmount());
        request.setRefundAmount(refundRequest.getRefundAmount());
        request.setRefundId(refundRequest.getRefundId());
        request.setRefundDesc(refundRequest.getRefundDesc());
        request.setNotifyUrl(refundRequest.getNotifyUrl());
        request.setPartnerId(refundRequest.getPartnerId());
        request.setVer(2);
        request.setExtendParams(refundRequest.getExtendParams());
        com.freemud.application.sdk.api.base.BaseResponse<OrderRefundResponse> checkParam = this.checkParam(refundRequest.getPartnerId(), refundRequest.getStoreId(), refundRequest.getRefundAmount());
        if (!Objects.equals(checkParam.getCode(), "100")) {
            return null;
        }
        return request;
    }

    /**
     * @param refundRequest
     * @return
     */
    private BaseResponse<PaymentQueryOrderResponseDto> queryPayOrder(PayRefundRequestDto refundRequest) {
        PaymentQueryOrderRequestDto paymentQueryOrderRequest = new PaymentQueryOrderRequestDto();

        paymentQueryOrderRequest.setPartnerId(refundRequest.getPartnerId());
        paymentQueryOrderRequest.setStoreId(refundRequest.getStoreId());
        paymentQueryOrderRequest.setFrontTransId(refundRequest.getOrgTransId());
        BaseResponse<PaymentQueryOrderResponseDto> payQueryOrderResponse = null;
        try {
            payQueryOrderResponse = paymentNewClient.payQueryOrder(paymentQueryOrderRequest);
        } catch (Exception e) {
            cn.freemud.base.log.ErrorLog.errorConvertJson(this.getClass(), "paymentcenter/queryOrder error", e);
        }
        if (payQueryOrderResponse == null) {
            return null;
        }
        return payQueryOrderResponse;
    }


    /**
     * 卖券调用退款
     *
     * @param reason
     * @param orderBean
     * @return -2正常 -1 不需要退款 0其他异常 1账户余额不足 2 系统异常
     */
    public PayRefundResponse refund(String reason, OrderBeanV1 orderBean) {
        PayRefundStatus refundStatus = PayRefundStatus.SUCCESS;

        BigDecimal refundAmount = new BigDecimal(orderBean.getAmount());
        AfterSalesOrderResp afterSalesOrder = getAfterSalesOrder(orderBean.getCompanyId(), orderBean.getOid());
        if (afterSalesOrder != null) {
            refundAmount = new BigDecimal(afterSalesOrder.getActualAmount());
        }
        PayRefundRequestDto orderRefundRequest = paymentSdkAdapter
                .getOrderRefundRequest(orderBean.getCompanyId(), orderBean.getShopId(), orderBean.getOid(), refundAmount, orderBean.getPayVoucher(), orderBean.getExtInfo(), reason);
        if (ObjectUtils.equals(orderBean.getAmount(), 0L)) {
            return handlePayRefundResponse(refundStatus, orderRefundRequest.getRefundId());
        }
        BaseResponse<OrderRefundResponse> orderRefundResponse;
        orderRefundResponse = this.orderPayRefund(orderRefundRequest);
        if (orderRefundResponse == null) {
            // 退款失败
            refundStatus = PayRefundStatus.FAIL;
            return handlePayRefundResponse(refundStatus, orderRefundRequest.getRefundId());
        }
        if (ObjectUtils.notEqual(orderRefundResponse.getCode(), SUCCESS)) {
            //商户余额不足的情况下，返回异常特殊处理.
            refundStatus = PayRefundStatus.FAIL;
            if (ResponseResult.NOT_SUFFICIENT_FUNDS.getCode().equals(orderRefundResponse.getCode())) {
                refundStatus = PayRefundStatus.NOT_SUFFICIENT_FUNDS;
            }
        }
        return handlePayRefundResponse(refundStatus, orderRefundRequest.getRefundId());
    }

    /**
     * 线下pos下单使用储值卡支付，储值卡退款
     *
     * @param orderBean
     * @return
     */
    public PayRefundResponse posOrderPayRefund(OrderBeanV1 orderBean, OrderExtInfoDto orderExtInfoDto) {
        PayRefundStatus refundStatus = PayRefundStatus.SUCCESS;
        PayRefundRequestDto refundRequest = paymentSdkAdapter.convert2OrderRefundNewRequest(orderBean, orderExtInfoDto);
        if (ObjectUtils.equals(orderBean.getAmount(), 0L)) {
            return handlePayRefundResponse(refundStatus, refundRequest.getRefundId());
        }
        BaseResponse<PayRefundData> orderRefundResponse;
        try {
            orderRefundResponse = paymentNewClient.payRefund(refundRequest);
        } catch (Exception ex) {
            ErrorLog.errorConvertJson(this.getClass(), "paymentNewService.newOrderRefundError", ex);
            throw new OrderServiceException(ResponseResult.REFUND_EXCEPTION);
        }
        if (orderRefundResponse == null || orderRefundResponse.getData() == null) {
            throw new OrderServiceException(ResponseResult.REFUND_EXCEPTION);
        }
        if (ObjectUtils.notEqual(orderRefundResponse.getCode(), SUCCESS)) {
            throw new OrderServiceException(ResponseResult.REFUND_FAIL, orderRefundResponse.getMessage());
        }
        if (ObjectUtils.equals(orderRefundResponse.getData().getResultCode(), 101)) {
            refundStatus = PayRefundStatus.SUCCESS;
            return handlePayRefundResponse(refundStatus, refundRequest.getRefundId());
        }
        refundStatus = ObjectUtils.equals(orderRefundResponse.getData().getResultCode(), 100) ? PayRefundStatus.SUCCESS : PayRefundStatus.FAIL;
        return handlePayRefundResponse(refundStatus, refundRequest.getRefundId());
    }

    /**
     * 获取退款售后单
     * @param partnerId 商户号
     * @param orderId 订单号
     * @return {@link AfterSalesOrderResp}
     */
    private AfterSalesOrderResp getAfterSalesOrder(String partnerId, String orderId) {
        OrderBaseResp<List<AfterSalesOrderResp>> listBaseResponse = orderSdkService.queryAfterSaleByOrderCode(partnerId, orderId);
        if (CollectionUtils.isNotEmpty(listBaseResponse.getResult())) {
            return listBaseResponse.getResult().get(0);
        }
        return null;
    }

    private PayRefundResponse handlePayRefundResponse(PayRefundStatus refundStatus, String refundId) {
        PayRefundResponse payRefundResponse = new PayRefundResponse();
        payRefundResponse.setPayRefundStatus(refundStatus);
        payRefundResponse.setRefundId(refundId);
        payRefundResponse.setMessage(refundStatus.getDesc());
        return payRefundResponse;
    }


    /**
     * 纯现金支付退款，非代付和混合支付退款
     */
    private BaseResponse<OrderRefundResponse> orderPayRefund(PayRefundRequestDto refundRequest) {

        // step1 查询支付结果
        BaseResponse<PaymentQueryOrderResponseDto> paymentQueryOrderResponseDtoBaseResponse = this.queryPayOrder(refundRequest);
        if (Objects.isNull(paymentQueryOrderResponseDtoBaseResponse)) {
            throw new OrderServiceException(ResponseResult.REFUND_EXCEPTION);
        }
        // step2 查询退款配置
        PayRefundRequestDto request = this.queryWxAppStore(paymentQueryOrderResponseDtoBaseResponse, refundRequest);
        if (Objects.isNull(request)) {
            throw new OrderServiceException(ResponseResult.CHECK_PARAM_ERROR);
        }

        // step3 退款
        BaseResponse<PayRefundData> refundNewResponse = null;
        try {
            refundNewResponse = paymentNewClient.payRefund(request);
        } catch (Exception e) {
            ErrorLog.errorConvertJson(this.getClass(), "paymentcenter/refund error", e);
        }

        if (refundNewResponse == null) {
            return null;
        }
        logUtil.info("paymentcenter/refund", JSONObject.toJSONString(request), JSONObject.toJSONString(refundNewResponse));
        //支付状态码取内部值
        if (Objects.equals(refundNewResponse.getCode(), "100") && refundNewResponse.getData() != null) {
            refundNewResponse.setCode(refundNewResponse.getData().getResultCode().toString());
            refundNewResponse.setMessage(refundNewResponse.getData().getResultMsg());
        }
        if (Objects.equals(refundNewResponse.getCode(), "100")) {
            PayRefundData refundData = refundNewResponse.getData();
            if (null != refundData) {
                return ResponseUtils.success(OrderCancelReqAdapter.convert(refundData));
            }
        }
        return ResponseUtils.error(refundNewResponse.getCode(), refundNewResponse.getMessage());
    }


    private com.freemud.application.sdk.api.base.BaseResponse<OrderRefundResponse> checkParam(String partnerId, String storeId, Long amount) {
        if (StringUtils.isBlank(partnerId)) {
            return ResponseUtils.error("501", "商户号不能为空");
        } else if (StringUtils.isBlank(storeId)) {
            return ResponseUtils.error("501", "门店号不能为空");
        } else if (amount == null) {
            return ResponseUtils.error("501", "金额不能为空");
        } else {
            return ResponseUtils.success();
        }
    }
}
