package cn.freemud.management.adapter;

import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import com.freemud.sdk.api.assortment.order.entities.other.OtherParamDTO;
import com.freemud.sdk.api.assortment.order.enums.StoreDeliveryMethod;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;

import java.util.Date;
import java.util.Objects;

public class BaseQueryOrderRequestAdapter {

    /**
     * 接单请求参数
     */
    public static BaseQueryOrderRequest getOrderConfirmRequest(OrderManagerRequest request, OrderBeanV1 orderBean, OtherParamDTO otherParamDTO) {
        BaseQueryOrderRequest orderRequest = new BaseQueryOrderRequest();
        orderRequest.setOrderId(orderBean.getOid());
        orderRequest.setShopId(orderBean.getShopId());
        orderRequest.setHasSelfDelivery(true);
        orderRequest.setPartnerId(orderBean.getCompanyId());
        orderRequest.setOrderType(OrderType.getOrderType(orderBean.getNewOrderType()));
        if (orderBean.getGmtExpect() != null && orderBean.getGmtExpect() != 0) {
            orderRequest.setExpectTime(cn.freemud.base.util.DateUtil.convert2String(new Date(orderBean.getGmtExpect()), cn.freemud.base.util.DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        }
        orderRequest.setOperator(request.getOperator());
        orderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());

        //配送信息为空，自配送
        if (orderBean.getAddInfo() == null || orderBean.getAddInfo().getDeliveryType() == null) {
            orderRequest.setDeliveryType(StoreDeliveryMethod.SELF.getCode());
        } else {
            orderRequest.setDeliveryType(orderBean.getAddInfo().getDeliveryType());
        }
        if (Objects.nonNull(otherParamDTO)) {
            orderRequest.setDispatchType(otherParamDTO.getDispatchType());
            orderRequest.setDispatchTimeout(otherParamDTO.getDispatchTimeout());
        }
        //订单宝自动接单提醒需求，传标识到基础服务识别
        if (Objects.equals(4,request.getOperationClient())) {
            orderRequest.setAcceptMode(1);
        }
        return orderRequest;
    }

}
