package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.order.OrderInvoiceConfigVo;
import cn.freemud.entities.vo.*;
import cn.freemud.entities.vo.order.CreateOrderInvoiceRequest;
import cn.freemud.entities.vo.order.GetInvoiceConfigRequest;
import cn.freemud.entities.vo.order.OrderAppealVo;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.response.OrderCountResp;

import java.util.List;
import java.util.Map;

/**
 * 订单服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public interface Orderservice extends OrderFactoryService{

    /**
     * 创建订单之前校验前面排队的订单数
     */
//    BaseResponse checkBeforeCreateOrder(CheckBeforeCreateOrderRequestVo checkBeforeCreateOrderRequestVo);

    /**
     * 创建订单
     */
//    BaseResponse createOrderNew(CreateOrderVo createOrderVo);

//    BaseResponse scanFaceCreateOrder(CreateOrderVo createOrderVo);

    /**
     * 支付回调
     */
    String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, OrderBeanV1> orderBeans);

    /**
     * 支付成功后回调通知_新版本
     */
    String newPaySuccessCallback(NewPaysuccessNoticeMessage message);

    /**
     * 退款回掉通知
     */
    String refundNotifyCallback(RefundNotifyCallbackRequestVo message);

    /**
     * 查询订单列表
     */
    BaseResponse queryOrders(QueryOrderVo queryOrderVo);

    /**
     * 查询订单列表
     */
    BaseResponse queryOrdersNew(QueryOrderVo queryOrderVo);

    /**
     * 支付取消删除订单
     */
    BaseResponse deleteOrder(DeleteOrderVo deleteOrderVo);

    /**
     * 通过订单号查询订单详情
     *
     * @param sessionId 用户会话ID
     * @param oid       订单ID
     * @return
     */
    BaseResponse queryOrderById(Integer operation, String sessionId, String oid, String partnerId, String channel, Integer isQueryAfterPay,Integer payGiftVer);

    BaseResponse cancelPayOrder(DeleteOrderVo deleteOrderVo);

    /**
     * 获取订单排队号
     */
    BaseResponse queryOrderQueueIndex(QueryOrderQueueIndexVo queryOrderQueueIndexVo);

    /**
     * 获取退款理由
     */
    @Deprecated
    BaseResponse getRefundReason(GetRefundReasonVo getRefundReasonVo);

    BaseResponse getNewRefundReason(GetRefundReasonVo getRefundReasonVo);

    /**
     * 创建积分订单
     *
     * @param vo
     * @return
     */
    BaseResponse createIntegralOrder(IntegralOrderVo vo);

    /**
     * @param queryOrderByConditionsRequestVo
     * @return
     * @用户积分订单列表
     */
    BaseResponse queryOrderByConditions(QueryOrderByConditionsRequestVo queryOrderByConditionsRequestVo);

    /**
     * 通过订单号查询订单详情
     *
     * @param sessionId 用户会话ID
     * @param oid       订单ID
     * @return
     */
    BaseResponse queryCollageOrderById(Integer operation, String sessionId, String oid, String partnerId, String channel);

//    BaseResponse timeOutOrderRefund(TimeOutOrderVo timeOutOrderVo);

    BaseResponse queryOrderRider(OrderRiderRequestVo requestVo);

    /**
     * 统计当日订单数
     *
     * @param queryOrderByConditionsRequestVo
     * @return
     */
    BaseResponse queryTodayOrders(QueryOrderByConditionsRequestVo queryOrderByConditionsRequestVo);



    /**
     * 拼团失败退款
     * @param refundVo
     * @return
     */
    BaseResponse spellGroupOrderFailRefund(SpellGroupFailRefundVo refundVo);


    BaseResponse scoreRecord(QueryOrderVo queryOrderVo);

    /**
     * 【ID1028455】 【订单】非码-腾讯有数数据上报V1.0.0
     * 每天6点前上报昨天数据
     *
     * @param orderCountRequestVo
     * @return
     */
    BaseResponse<List<OrderCountResp>> selectCountOrdersByPartnerIds(OrderCountRequestVo orderCountRequestVo, String trackingNo);


    /**
     * 通过订单号查询订单详情
     *
     * @param orderCode 订单编号
     * @param partnerId 商户号
     * @param orderClient 订单下单渠道
     * @return
     */
    BaseResponse<OrderStateMonitorInfoVo> queryOrderStateMonitorInfo(String orderCode, String partnerId, Byte orderClient);

    BaseResponse submitAppeal(OrderAppealVo orderAppealVo);

    BaseResponse queryOrderAppeal(OrderAppealVo orderAppealVo);

    /**
     * 2021年9月15日-开票历史列表接口+详情接口+发票所含订单接口-黄兆良
     * 查询开票历史列表
     */
    BaseResponse queryInvoiceList(QueryInvoiceReq queryInvoiceReq);

    BaseResponse createAndGetOrderInvoice(CreateOrderInvoiceRequest request);

    BaseResponse<OrderInvoiceConfigVo> queryInvoiceConfig(GetInvoiceConfigRequest request);

    /**
     * 卖券订单 申请退款
     * @param orderRefundVo
     * @param flag 0 用户调用 1系统调用
     * @return
     */
    BaseResponse couponOrderRefund(OrderRefundVo orderRefundVo, int flag);

    /**
     *  卖券订单 申请退款 重试
     * @param orderRefundRetryVo
     * @return
     */
    BaseResponse couponOrderRefundRetry(OrderRefundRetryVo orderRefundRetryVo);


}
