package cn.freemud.enums;

/**
 * 配送渠道枚举
 * @version V1.0
 * @author: kai.ding
 * @date:  
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * All rights Reserved, Designed By www.freemud.cn
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public enum DeliveryChannelEnum {

    WEIXIN("weixin","微信"),
    ;

    private String code;
    private String desc;

    DeliveryChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DeliveryChannelEnum getByCode(String code) {
        for (DeliveryChannelEnum payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
