/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetActivitiesResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 17:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
public class GetActivitiesResponseDto {
    /**
     * code : 100
     * message : 查询成功
     * result : [{"activityName":"满减活动","createTime":"2018-08-01 20:31:16","endTime":"2018-08-30 00:00:00","fullSubConfigs":[{"activityId":121347407098150912,"full":2000,"sub":500},{"activityId":121347407098150912,"full":3000,"sub":700},{"activityId":121347407098150912,"full":5000,"sub":1000}],"id":121347407098150912,"memo":"8月1日起开始满减活动","partnerId":"234234","startTime":"2018-08-01 00:00:00","status":"1","type":1}]
     * ver : 1
     */

    private String code;
    private String message;
    private String ver;
    @NoArgsConstructor
    @Data
    public static class PromotionActivity {
        /**
         * activityName : 满减活动
         * createTime : 2018-08-01 20:31:16
         * endTime : 2018-08-30 00:00:00
         * fullSubConfigs : [{"activityId":121347407098150912,"full":2000,"sub":500},{"activityId":121347407098150912,"full":3000,"sub":700},{"activityId":121347407098150912,"full":5000,"sub":1000}]
         * id : 121347407098150912
         * memo : 8月1日起开始满减活动
         * partnerId : 234234
         * startTime : 2018-08-01 00:00:00
         * status : 1
         * type : 1
         */
        /**
         * 活动ID
         */
        private Long id;
        /**
         * 是否与其他活动同享
         */
        private Boolean share;
        /**
         * 活动名称
         */
        private String activityName;
        /**
         * 创建时间
         */
        private String createTime;

        private Date createDate;
        /**
         * 开始时间
         */
        private String startTime;
        /**
         * 结束时间
         */
        private String endTime;
        /**
         * 商户ID
         */
        private String partnerId;

        private String memo;
        /**
         * 活动状态 0 为未开始 1 已开始 2已暂停
         */
        private Integer status;
        /**
         * 活动类型 1满减
         */
        private Integer type;
        private List<FullSubConfigBean> fullSubConfigs;

        @NoArgsConstructor
        @Data
        public static class FullSubConfigBean {
            /**
             * activityId : 121347407098150912
             * full : 2000
             * sub : 500
             */

            /**
             * 活动ID
             */
            private Long activityId;
            /**
             * 满多少 单位分
             */
            private Long full;

            /**
             * 减多少单位分
             */
            private Long sub;
        }

        /**
         * 限时折扣商品信息集合
         */
        private List<LimitConfigList> limitConfigList;

        @NoArgsConstructor
        @Data
        public static class LimitConfigList {

            private Long activityId;

            /**
             * sku商品spuID
             */
            private String spuId;
            /**
             * sku商品ID
             */
            private String skuId;
            /**
             * 商品名称
             */
            private String skuName;
            /**
             * 商品原价
             */
            private Long originPrice;
            /**
             * 商品售卖价格
             */
            private Long salePrice;
            /**
             * 每笔订单限制购买数量
             */
            private Integer limitPerOrder;
            /**
             * 特价商品数量
             */
            private int limitStock;
            /**
             * 特价商品剩余可购买数量
             */
            private Integer remainStock;
            /**
             * 多规格商品是否只有一个sku商品参与限时特价
             */
            private boolean oneSkuId;

        }
    }

    private Object result;
}
