package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.pay.SVCCardAmountRequest;
import cn.freemud.entities.dto.pay.SVCCardAmountResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name="fm-svc-app", url = "${saas.svc.app.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface SvcAppClient {


    //批量查询卡余额
    @PostMapping(value = "/svc/card/batch-query-card-amount")
    @IgnoreFeignLogAnnotation(logMessage = "batchQueryCardAmount",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    BaseResponse<SVCCardAmountResponse> batchQueryCardAmount(SVCCardAmountRequest svcComPayRequestDto);

}
