package cn.freemud.handle;

import cn.freemud.entities.dto.console.*;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.enums.OrderType;
import cn.freemud.service.thirdparty.ConsoleApiClient;
import com.freemud.application.sdk.api.log.ApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/23 上午11:58
 * @description :
 */
@Component
public class CommonFunctionHandle {


    @Autowired
    private ConsoleApiClient consoleApiClient;

    /**
     * fisherman 【ID1033456】自提根据模板配置计算餐具包装费
     *
     * @param shoppingCartInfoRequestVo
     * @param newPackAmount
     * @return 外卖 true 打包带走 false  null 为其他业务问题 不进入需求
     */
    public Long getPackAmountByStoreConfig(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo, Long newPackAmount) {
        if (Objects.isNull(shoppingCartInfoRequestVo)) {
            return newPackAmount;
        }
        Boolean isTakeOut = null;
        if (Objects.equals(shoppingCartInfoRequestVo.getOrderType(), CreateOrderType.TAKE_OUT.getCode())) {
            isTakeOut = true;
        } else if (Objects.equals(shoppingCartInfoRequestVo.getReachStoreType(), OrderType.COLLECT_GOODS.getCode())) {
            isTakeOut = false;
        }
        ApiLog.printLog("自提根据模板配置计算餐具包装费", String.valueOf(newPackAmount), String.valueOf(isTakeOut), null);
        if (Objects.isNull(newPackAmount) || newPackAmount.compareTo(0L) == 0) {
            return 0L;
        }
        if (Objects.isNull(isTakeOut)) {
            return newPackAmount;
        }
        GetStoreMixRequest request = GetStoreMixRequest.builder().partnerId(shoppingCartInfoRequestVo.getPartnerId()).storeCode(shoppingCartInfoRequestVo.getShopId()).build();
        // 查询 业务设置信息数据
        request.setQuery(QueryFlag.builder().queryBusinessInfo(Boolean.TRUE).build());
        ConsoleResponseDTO<BizDTO> responseDTO = consoleApiClient.getStoreMix(request);
        BizDTO bizVO = responseDTO.getBizVO();
        if (Objects.nonNull(bizVO) && Objects.nonNull(bizVO.getBusinessInfo())) {
            // 查出 有配置 并且有开关 就判断 否则就走 默认值
            ExpandFieldsDTO expandFields = bizVO.getBusinessInfo().getExpandFields();
            if (Objects.nonNull(expandFields)) {
                if (isTakeOut) {
                    // 外卖 是否计算 包装费
                    if (Objects.nonNull(expandFields.getDeliveryPackageFeeSwitch())
                            && ExpandFieldsDTO.STR_FALSE.equals(expandFields.getDeliveryPackageFeeSwitch())) {
                        return 0L;
                    }
                } else {
                    // 打包带走 是否计算包装费
                    if (Objects.nonNull(expandFields.getPickupPackageFeeSwitch())
                            && ExpandFieldsDTO.STR_FALSE.equals(expandFields.getPickupPackageFeeSwitch())) {
                        return 0L;
                    }
                }
            }
        }
        return newPackAmount;
    }

}
