package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class SpuProductBeanVo {

    /**
     * 商品ID
     */
    private String spuId;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 标准价格  精确到分
     */
    private Long originalPrice;
    /**
     * 销售价
     */
    private Long finalPrice;
    /**
     * 默认图片
     */
    private String picture;
    /**
     * 产品组信息
     */
    List<ProductGroupDto> productGroups;

    List<SkuProductBean> skuList;


    /**
     * 商品标签信息
     */
    List<ProductVo.ProductLabel> productLabels;
    /**
     * 商品类型  1=普通商品,2=附加商品,3=组合商品，4=固定套餐，5=组合套餐
     */
    private Integer type;
    /**
     * 描述
     */
    private String specification;
    /**
     * 备注
     */
    private String remark;
    /**
     * 商品排序
     */
    private int sequence;
    /**
     * 商品数量
     */
    private Integer qty;
    /**
     * 商品状态   1 下架 2 上架 3 售罄 ，已卖光
     */
    private Integer status;

    private String statusDesc;


    @NoArgsConstructor
    @Data
    public class ProductGroupDto {

        private String name;
        private List<cn.freemud.entities.dto.ProductGroupDto.GroupDetailBean> groupDetail;

    }

    @NoArgsConstructor
    @Data
    public class SkuProductBean {

        private String skuId;


    }


}
