package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum OrderAccountTypeV1 {

    OTHER("其他", "OTHER",0,0),
    DELIVERY_AMOUNT( "配送费", "DELIVERY_AMOUNT",1,1),
    BUY_DISCOUNT("满减优惠", "BUY_DISCOUNT",2,2),
    PACK_AMOUNT("包装费", "PACK_AMOUNT",3,3),
    COUPON( "代金券", "COUPON",5,10),
    PRODUCT_COUPON("商品券", "PRODUCT_COUPON",6,118),
    B3S1_COUPON( "买3赠1券", "B3S1_COUPON",35,35),
    SEED_PRODUCT_COUPON( "种子券", "SEED_PRODUCT_COUPON",37,37),
    EVM_PRODUCT_COUPON( "EVM券", "EVM_PRODUCT_COUPON",39,39),
    DISCOUNT_COUPON("折扣券", "DISCOUNT_COUPON",7,208),
    DRIVER_FEE( "骑手小费", "DRIVER_FEE",7,7),
    WITH_ORDER_BUY_COUPON_FEE( "随单买月卡", "WITH_ORDER_BUY_COUPON_FEE",10,10),
    FREIGHT_COUPON( "运费券", "FREIGHT_COUPON",99,99),
    DISCOUNT_AMOUNT( "限时折扣", "DISCOUNT_AMOUNT",21,206),
    PREMIUM_EXCHANGE( "加价购", "PREMIUM_EXCHANGE",22,46),
    SECOND_DISCOUNT( "第二件N折", "SECOND_DISCOUNT",23,20),
    BUYM_SENDN( "买M赠N", "BUYM_SENDN",24,23),
    SUPER_PURCHASE( "超值加购", "SUPER_PURCHASE",47,47),
    CUSTOMER_SCORE( "积分兑换", "CUSTOMER_SCORE",4,200),
    WEIXIN("微信优惠","WECHAT_DISCOUNT",203,203),
    ALIPAY("支付宝优惠","ALIPAY_DISCOUNT",204,204),
    CARD_ORIGINAL_AMOUNT( "会员卡原价", "CARD_ORIGINAL_AMOUNT",25,5),
    SET_MEAL( "套餐商品优惠", "SET_MEAL",211,211),
    CARD_DISCOUNT_AMOUNT( "会员卡优惠金额", "CARD_DISCOUNT_AMOUNT",26,215),
    XY_DISCOUNT( "x件y折", "XY_DISCOUNT",104,104),
    FULL_DISTRIBUTION_FEE( "满减配送费", "FULL_DISTRIBUTION_FEE",1014,1014),
    NEW_USER_DISCOUNT( "新用户立减", "NEW_USER_DISCOUNT",101,1),
    PRICE_DEDUCTION_COUPON( "抵价券", "PRICE_DEDUCTION_COUPON",103,3),
    TOTAL_DISCOUNT( "优惠总金额", "TOTAL_DISCOUNT",205,205),
    MONTH_CARD_TOTAL_DISCOUNT( "月享卡优惠总金额", "MONTH_CARD_TOTAL_DISCOUNT",231,231),
    GATHER_SPOT( "集点活动","GATHER_SPOT",221,221),
    MEMBER_PRICE_DISCOUNT( "会员价优惠", "MEMBER_PRICE_DISCOUNT",220,220),
    COCO_PRODUCT_CASH_COUPON( "coco商品代金券","COCO_PRODUCT_CASH_COUPON",36,36),
    FULL_BUYM_SENDN( "满赠","FULL_BUYM_SENDN",230,230),
    SCORE_PRODUCT_ACTIVITY( "积分商品活动","SCORE_PRODUCT_ACTIVITY",28,28),
    SINGLE_PRODUCT_REDUCTION( "单品立减","SINGLE_PRODUCT_REDUCTION",22,22)


    ;


    private String desc;

    private String message;

    private Integer v1code;

    private Integer v2code;


    /**
     * 获取V1 老订单状态值
     */
    public static Integer getOldCode(Integer v2Code) {
        Integer v1Code = v2Code;
        if (v2Code == null ) return v1Code;
        for (OrderStatusV1 value : OrderStatusV1.values()) {
            if (value.getV2Code().equals(v2Code)) {
                v1Code = value.getV1Code();
                break;
            }
        }
        return v1Code;
    }


    OrderAccountTypeV1(String desc, String message, Integer v1code, Integer v2code) {
        this.desc = desc;
        this.message = message;
        this.v1code = v1code;
        this.v2code = v2code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getV1code() {
        return v1code;
    }

    public void setV1code(Integer v1code) {
        this.v1code = v1code;
    }

    public Integer getV2code() {
        return v2code;
    }

    public void setV2code(Integer v2code) {
        this.v2code = v2code;
    }
}
