package cn.freemud.management.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderRefundEnum
 * @Package cn.freemud.constant
 * @Description:
 * @author: bowen.hu
 * @date: 2019-09-17 10:46
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public enum OrderRefundEnum {

    ORDER_REFUND("orderRefund", "已完成订单是否允许退款"),
    TAKEORDER_REFUND("takeOrderRefund", "未接单是否支持退款"),
    RECEIPTORDER_REFUND("receiptOrderRefund", "已接单是否支持退款"),
    COMPLETEMAKEORDER_REFUND("completeMakeOrderRefund", "制作完成是否支持退款"),

    DELIVERY_TAKE_ORDER_REFUND("deliveryTakeOrderRefund","外卖单未接单是否支持退款"),
    DELIVERY_RECEIPT_ORDER_REFUND("deliveryReceiptOrderRefund","外卖单已接单是否支持退款"),
    DELIVERY_COMPLETE_MAKE_ORDER_REFUND("deliveryCompleteMakeOrderRefund","外卖单制作完成是否支持退款"),
    DELIVERY_ORDER_REFUND("deliveryOrderRefund","外卖单订单完成是否支持退款"),
    REFUND_DATA_RANGE("refundDateRange", "退款允许日期"),
    REFUND_DELIVERY_FEE_ENABLE("refundShippingFee","商家同意退款时是否退配送费"),
    REFUND_REVERSE_COUPON("refundReverseCoupon", "退款退优惠券");

    private String keyValue;

    private String message;

    OrderRefundEnum(String keyValue, String message) {
        this.keyValue = keyValue;
        this.message = message;
    }

    public String getKeyValue() {
        return keyValue;
    }

    public String getMessage() {
        return message;
    }


}
