package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.*;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;

import java.util.Map;

/**
 * 订单服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public interface MCCafeOrderService {

    /**
     * 创建麦咖啡订单
     */
    BaseResponse createMCCafeOrder(CreateOrderVo createOrderVo);

    /**
     * 麦咖啡支付成功回调
     */
    String mcCafePaySuccessCallback(NewPaysuccessNoticeMessage message);

    /**
     * 支付回调
     */
    String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, OrderBeanV1> orderBeans);

    /**
     * 麦咖啡订单申请退款
     */
    BaseResponse orderRefund(OrderRefundVo orderRefundVo);

    /**
     * 退款回掉通知
     */
    String mcCafeRefundNotifyCallback(RefundNotifyCallbackRequestVo message);

    BaseResponse mcCafeQueryOrderById(MaCafeQueryOrderVo queryOrderVo);

    BaseResponse mcCafeQueryOrders(McCafeQueryOrderVo queryOrderVo);

    BaseResponse mcCafePollingPickUpCode(MaCafeQueryOrderVo vo);

    BaseResponse reminder(ReminderVo reminderVo);

    BaseResponse listFreeRider(FreeRiderPositionVo vo);

    /**
     * 查询麦咖啡最近已完成的一单
     */
    BaseResponse mcCafeQueryRecentOrder(McCafeQueryOrderVo queryOrderVo);

}
